// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.RecipientsContractProperties;
import java.io.IOException;

/**
 * Notification details.
 */
@Fluent
public final class NotificationContractInner extends ProxyResource {
    /*
     * Notification entity contract properties.
     */
    private NotificationContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of NotificationContractInner class.
     */
    public NotificationContractInner() {
    }

    /**
     * Get the innerProperties property: Notification entity contract properties.
     * 
     * @return the innerProperties value.
     */
    private NotificationContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the title property: Title of the Notification.
     * 
     * @return the title value.
     */
    public String title() {
        return this.innerProperties() == null ? null : this.innerProperties().title();
    }

    /**
     * Set the title property: Title of the Notification.
     * 
     * @param title the title value to set.
     * @return the NotificationContractInner object itself.
     */
    public NotificationContractInner withTitle(String title) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NotificationContractProperties();
        }
        this.innerProperties().withTitle(title);
        return this;
    }

    /**
     * Get the description property: Description of the Notification.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Description of the Notification.
     * 
     * @param description the description value to set.
     * @return the NotificationContractInner object itself.
     */
    public NotificationContractInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NotificationContractProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the recipients property: Recipient Parameter values.
     * 
     * @return the recipients value.
     */
    public RecipientsContractProperties recipients() {
        return this.innerProperties() == null ? null : this.innerProperties().recipients();
    }

    /**
     * Set the recipients property: Recipient Parameter values.
     * 
     * @param recipients the recipients value to set.
     * @return the NotificationContractInner object itself.
     */
    public NotificationContractInner withRecipients(RecipientsContractProperties recipients) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NotificationContractProperties();
        }
        this.innerProperties().withRecipients(recipients);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NotificationContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NotificationContractInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NotificationContractInner.
     */
    public static NotificationContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NotificationContractInner deserializedNotificationContractInner = new NotificationContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedNotificationContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedNotificationContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedNotificationContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedNotificationContractInner.innerProperties
                        = NotificationContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNotificationContractInner;
        });
    }
}
