// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.RecipientsContractProperties;
import java.io.IOException;

/**
 * Notification Contract properties.
 */
@Fluent
public final class NotificationContractProperties implements JsonSerializable<NotificationContractProperties> {
    /*
     * Title of the Notification.
     */
    private String title;

    /*
     * Description of the Notification.
     */
    private String description;

    /*
     * Recipient Parameter values.
     */
    private RecipientsContractProperties recipients;

    /**
     * Creates an instance of NotificationContractProperties class.
     */
    public NotificationContractProperties() {
    }

    /**
     * Get the title property: Title of the Notification.
     * 
     * @return the title value.
     */
    public String title() {
        return this.title;
    }

    /**
     * Set the title property: Title of the Notification.
     * 
     * @param title the title value to set.
     * @return the NotificationContractProperties object itself.
     */
    public NotificationContractProperties withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the description property: Description of the Notification.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the Notification.
     * 
     * @param description the description value to set.
     * @return the NotificationContractProperties object itself.
     */
    public NotificationContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the recipients property: Recipient Parameter values.
     * 
     * @return the recipients value.
     */
    public RecipientsContractProperties recipients() {
        return this.recipients;
    }

    /**
     * Set the recipients property: Recipient Parameter values.
     * 
     * @param recipients the recipients value to set.
     * @return the NotificationContractProperties object itself.
     */
    public NotificationContractProperties withRecipients(RecipientsContractProperties recipients) {
        this.recipients = recipients;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (title() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property title in model NotificationContractProperties"));
        }
        if (recipients() != null) {
            recipients().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(NotificationContractProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("recipients", this.recipients);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NotificationContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NotificationContractProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NotificationContractProperties.
     */
    public static NotificationContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NotificationContractProperties deserializedNotificationContractProperties
                = new NotificationContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("title".equals(fieldName)) {
                    deserializedNotificationContractProperties.title = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedNotificationContractProperties.description = reader.getString();
                } else if ("recipients".equals(fieldName)) {
                    deserializedNotificationContractProperties.recipients
                        = RecipientsContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNotificationContractProperties;
        });
    }
}
