// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * OpenID Connect Providers Contract.
 */
@Fluent
public final class OpenidConnectProviderContractProperties
    implements JsonSerializable<OpenidConnectProviderContractProperties> {
    /*
     * User-friendly OpenID Connect Provider name.
     */
    private String displayName;

    /*
     * User-friendly description of OpenID Connect Provider.
     */
    private String description;

    /*
     * Metadata endpoint URI.
     */
    private String metadataEndpoint;

    /*
     * Client ID of developer console which is the client application.
     */
    private String clientId;

    /*
     * Client Secret of developer console which is the client application.
     */
    private String clientSecret;

    /*
     * If true, the Open ID Connect provider may be used in the developer portal test console. True by default if no
     * value is provided.
     */
    private Boolean useInTestConsole;

    /*
     * If true, the Open ID Connect provider will be used in the API documentation in the developer portal. False by
     * default if no value is provided.
     */
    private Boolean useInApiDocumentation;

    /**
     * Creates an instance of OpenidConnectProviderContractProperties class.
     */
    public OpenidConnectProviderContractProperties() {
    }

    /**
     * Get the displayName property: User-friendly OpenID Connect Provider name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: User-friendly OpenID Connect Provider name.
     * 
     * @param displayName the displayName value to set.
     * @return the OpenidConnectProviderContractProperties object itself.
     */
    public OpenidConnectProviderContractProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: User-friendly description of OpenID Connect Provider.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: User-friendly description of OpenID Connect Provider.
     * 
     * @param description the description value to set.
     * @return the OpenidConnectProviderContractProperties object itself.
     */
    public OpenidConnectProviderContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the metadataEndpoint property: Metadata endpoint URI.
     * 
     * @return the metadataEndpoint value.
     */
    public String metadataEndpoint() {
        return this.metadataEndpoint;
    }

    /**
     * Set the metadataEndpoint property: Metadata endpoint URI.
     * 
     * @param metadataEndpoint the metadataEndpoint value to set.
     * @return the OpenidConnectProviderContractProperties object itself.
     */
    public OpenidConnectProviderContractProperties withMetadataEndpoint(String metadataEndpoint) {
        this.metadataEndpoint = metadataEndpoint;
        return this;
    }

    /**
     * Get the clientId property: Client ID of developer console which is the client application.
     * 
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: Client ID of developer console which is the client application.
     * 
     * @param clientId the clientId value to set.
     * @return the OpenidConnectProviderContractProperties object itself.
     */
    public OpenidConnectProviderContractProperties withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the clientSecret property: Client Secret of developer console which is the client application.
     * 
     * @return the clientSecret value.
     */
    public String clientSecret() {
        return this.clientSecret;
    }

    /**
     * Set the clientSecret property: Client Secret of developer console which is the client application.
     * 
     * @param clientSecret the clientSecret value to set.
     * @return the OpenidConnectProviderContractProperties object itself.
     */
    public OpenidConnectProviderContractProperties withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    /**
     * Get the useInTestConsole property: If true, the Open ID Connect provider may be used in the developer portal test
     * console. True by default if no value is provided.
     * 
     * @return the useInTestConsole value.
     */
    public Boolean useInTestConsole() {
        return this.useInTestConsole;
    }

    /**
     * Set the useInTestConsole property: If true, the Open ID Connect provider may be used in the developer portal test
     * console. True by default if no value is provided.
     * 
     * @param useInTestConsole the useInTestConsole value to set.
     * @return the OpenidConnectProviderContractProperties object itself.
     */
    public OpenidConnectProviderContractProperties withUseInTestConsole(Boolean useInTestConsole) {
        this.useInTestConsole = useInTestConsole;
        return this;
    }

    /**
     * Get the useInApiDocumentation property: If true, the Open ID Connect provider will be used in the API
     * documentation in the developer portal. False by default if no value is provided.
     * 
     * @return the useInApiDocumentation value.
     */
    public Boolean useInApiDocumentation() {
        return this.useInApiDocumentation;
    }

    /**
     * Set the useInApiDocumentation property: If true, the Open ID Connect provider will be used in the API
     * documentation in the developer portal. False by default if no value is provided.
     * 
     * @param useInApiDocumentation the useInApiDocumentation value to set.
     * @return the OpenidConnectProviderContractProperties object itself.
     */
    public OpenidConnectProviderContractProperties withUseInApiDocumentation(Boolean useInApiDocumentation) {
        this.useInApiDocumentation = useInApiDocumentation;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (displayName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property displayName in model OpenidConnectProviderContractProperties"));
        }
        if (metadataEndpoint() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property metadataEndpoint in model OpenidConnectProviderContractProperties"));
        }
        if (clientId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property clientId in model OpenidConnectProviderContractProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(OpenidConnectProviderContractProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("metadataEndpoint", this.metadataEndpoint);
        jsonWriter.writeStringField("clientId", this.clientId);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("clientSecret", this.clientSecret);
        jsonWriter.writeBooleanField("useInTestConsole", this.useInTestConsole);
        jsonWriter.writeBooleanField("useInApiDocumentation", this.useInApiDocumentation);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OpenidConnectProviderContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OpenidConnectProviderContractProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OpenidConnectProviderContractProperties.
     */
    public static OpenidConnectProviderContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OpenidConnectProviderContractProperties deserializedOpenidConnectProviderContractProperties
                = new OpenidConnectProviderContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("displayName".equals(fieldName)) {
                    deserializedOpenidConnectProviderContractProperties.displayName = reader.getString();
                } else if ("metadataEndpoint".equals(fieldName)) {
                    deserializedOpenidConnectProviderContractProperties.metadataEndpoint = reader.getString();
                } else if ("clientId".equals(fieldName)) {
                    deserializedOpenidConnectProviderContractProperties.clientId = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedOpenidConnectProviderContractProperties.description = reader.getString();
                } else if ("clientSecret".equals(fieldName)) {
                    deserializedOpenidConnectProviderContractProperties.clientSecret = reader.getString();
                } else if ("useInTestConsole".equals(fieldName)) {
                    deserializedOpenidConnectProviderContractProperties.useInTestConsole
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("useInApiDocumentation".equals(fieldName)) {
                    deserializedOpenidConnectProviderContractProperties.useInApiDocumentation
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOpenidConnectProviderContractProperties;
        });
    }
}
