// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters supplied to the Update OpenID Connect Provider operation.
 */
@Fluent
public final class OpenidConnectProviderUpdateContractProperties
    implements JsonSerializable<OpenidConnectProviderUpdateContractProperties> {
    /*
     * User-friendly OpenID Connect Provider name.
     */
    private String displayName;

    /*
     * User-friendly description of OpenID Connect Provider.
     */
    private String description;

    /*
     * Metadata endpoint URI.
     */
    private String metadataEndpoint;

    /*
     * Client ID of developer console which is the client application.
     */
    private String clientId;

    /*
     * Client Secret of developer console which is the client application.
     */
    private String clientSecret;

    /*
     * If true, the Open ID Connect provider may be used in the developer portal test console. True by default if no
     * value is provided.
     */
    private Boolean useInTestConsole;

    /*
     * If true, the Open ID Connect provider will be used in the API documentation in the developer portal. False by
     * default if no value is provided.
     */
    private Boolean useInApiDocumentation;

    /**
     * Creates an instance of OpenidConnectProviderUpdateContractProperties class.
     */
    public OpenidConnectProviderUpdateContractProperties() {
    }

    /**
     * Get the displayName property: User-friendly OpenID Connect Provider name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: User-friendly OpenID Connect Provider name.
     * 
     * @param displayName the displayName value to set.
     * @return the OpenidConnectProviderUpdateContractProperties object itself.
     */
    public OpenidConnectProviderUpdateContractProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: User-friendly description of OpenID Connect Provider.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: User-friendly description of OpenID Connect Provider.
     * 
     * @param description the description value to set.
     * @return the OpenidConnectProviderUpdateContractProperties object itself.
     */
    public OpenidConnectProviderUpdateContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the metadataEndpoint property: Metadata endpoint URI.
     * 
     * @return the metadataEndpoint value.
     */
    public String metadataEndpoint() {
        return this.metadataEndpoint;
    }

    /**
     * Set the metadataEndpoint property: Metadata endpoint URI.
     * 
     * @param metadataEndpoint the metadataEndpoint value to set.
     * @return the OpenidConnectProviderUpdateContractProperties object itself.
     */
    public OpenidConnectProviderUpdateContractProperties withMetadataEndpoint(String metadataEndpoint) {
        this.metadataEndpoint = metadataEndpoint;
        return this;
    }

    /**
     * Get the clientId property: Client ID of developer console which is the client application.
     * 
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: Client ID of developer console which is the client application.
     * 
     * @param clientId the clientId value to set.
     * @return the OpenidConnectProviderUpdateContractProperties object itself.
     */
    public OpenidConnectProviderUpdateContractProperties withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the clientSecret property: Client Secret of developer console which is the client application.
     * 
     * @return the clientSecret value.
     */
    public String clientSecret() {
        return this.clientSecret;
    }

    /**
     * Set the clientSecret property: Client Secret of developer console which is the client application.
     * 
     * @param clientSecret the clientSecret value to set.
     * @return the OpenidConnectProviderUpdateContractProperties object itself.
     */
    public OpenidConnectProviderUpdateContractProperties withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    /**
     * Get the useInTestConsole property: If true, the Open ID Connect provider may be used in the developer portal test
     * console. True by default if no value is provided.
     * 
     * @return the useInTestConsole value.
     */
    public Boolean useInTestConsole() {
        return this.useInTestConsole;
    }

    /**
     * Set the useInTestConsole property: If true, the Open ID Connect provider may be used in the developer portal test
     * console. True by default if no value is provided.
     * 
     * @param useInTestConsole the useInTestConsole value to set.
     * @return the OpenidConnectProviderUpdateContractProperties object itself.
     */
    public OpenidConnectProviderUpdateContractProperties withUseInTestConsole(Boolean useInTestConsole) {
        this.useInTestConsole = useInTestConsole;
        return this;
    }

    /**
     * Get the useInApiDocumentation property: If true, the Open ID Connect provider will be used in the API
     * documentation in the developer portal. False by default if no value is provided.
     * 
     * @return the useInApiDocumentation value.
     */
    public Boolean useInApiDocumentation() {
        return this.useInApiDocumentation;
    }

    /**
     * Set the useInApiDocumentation property: If true, the Open ID Connect provider will be used in the API
     * documentation in the developer portal. False by default if no value is provided.
     * 
     * @param useInApiDocumentation the useInApiDocumentation value to set.
     * @return the OpenidConnectProviderUpdateContractProperties object itself.
     */
    public OpenidConnectProviderUpdateContractProperties withUseInApiDocumentation(Boolean useInApiDocumentation) {
        this.useInApiDocumentation = useInApiDocumentation;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("metadataEndpoint", this.metadataEndpoint);
        jsonWriter.writeStringField("clientId", this.clientId);
        jsonWriter.writeStringField("clientSecret", this.clientSecret);
        jsonWriter.writeBooleanField("useInTestConsole", this.useInTestConsole);
        jsonWriter.writeBooleanField("useInApiDocumentation", this.useInApiDocumentation);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OpenidConnectProviderUpdateContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OpenidConnectProviderUpdateContractProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OpenidConnectProviderUpdateContractProperties.
     */
    public static OpenidConnectProviderUpdateContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OpenidConnectProviderUpdateContractProperties deserializedOpenidConnectProviderUpdateContractProperties
                = new OpenidConnectProviderUpdateContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("displayName".equals(fieldName)) {
                    deserializedOpenidConnectProviderUpdateContractProperties.displayName = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedOpenidConnectProviderUpdateContractProperties.description = reader.getString();
                } else if ("metadataEndpoint".equals(fieldName)) {
                    deserializedOpenidConnectProviderUpdateContractProperties.metadataEndpoint = reader.getString();
                } else if ("clientId".equals(fieldName)) {
                    deserializedOpenidConnectProviderUpdateContractProperties.clientId = reader.getString();
                } else if ("clientSecret".equals(fieldName)) {
                    deserializedOpenidConnectProviderUpdateContractProperties.clientSecret = reader.getString();
                } else if ("useInTestConsole".equals(fieldName)) {
                    deserializedOpenidConnectProviderUpdateContractProperties.useInTestConsole
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("useInApiDocumentation".equals(fieldName)) {
                    deserializedOpenidConnectProviderUpdateContractProperties.useInApiDocumentation
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOpenidConnectProviderUpdateContractProperties;
        });
    }
}
