// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ParameterContract;
import com.azure.resourcemanager.apimanagement.models.RequestContract;
import com.azure.resourcemanager.apimanagement.models.ResponseContract;
import java.io.IOException;
import java.util.List;

/**
 * API Operation details.
 */
@Fluent
public final class OperationContractInner extends ProxyResource {
    /*
     * Properties of the Operation Contract.
     */
    private OperationContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of OperationContractInner class.
     */
    public OperationContractInner() {
    }

    /**
     * Get the innerProperties property: Properties of the Operation Contract.
     * 
     * @return the innerProperties value.
     */
    private OperationContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the displayName property: Operation Name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: Operation Name.
     * 
     * @param displayName the displayName value to set.
     * @return the OperationContractInner object itself.
     */
    public OperationContractInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationContractProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the method property: A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited
     * by only them.
     * 
     * @return the method value.
     */
    public String method() {
        return this.innerProperties() == null ? null : this.innerProperties().method();
    }

    /**
     * Set the method property: A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited
     * by only them.
     * 
     * @param method the method value to set.
     * @return the OperationContractInner object itself.
     */
    public OperationContractInner withMethod(String method) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationContractProperties();
        }
        this.innerProperties().withMethod(method);
        return this;
    }

    /**
     * Get the urlTemplate property: Relative URL template identifying the target resource for this operation. May
     * include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}.
     * 
     * @return the urlTemplate value.
     */
    public String urlTemplate() {
        return this.innerProperties() == null ? null : this.innerProperties().urlTemplate();
    }

    /**
     * Set the urlTemplate property: Relative URL template identifying the target resource for this operation. May
     * include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}.
     * 
     * @param urlTemplate the urlTemplate value to set.
     * @return the OperationContractInner object itself.
     */
    public OperationContractInner withUrlTemplate(String urlTemplate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationContractProperties();
        }
        this.innerProperties().withUrlTemplate(urlTemplate);
        return this;
    }

    /**
     * Get the templateParameters property: Collection of URL template parameters.
     * 
     * @return the templateParameters value.
     */
    public List<ParameterContract> templateParameters() {
        return this.innerProperties() == null ? null : this.innerProperties().templateParameters();
    }

    /**
     * Set the templateParameters property: Collection of URL template parameters.
     * 
     * @param templateParameters the templateParameters value to set.
     * @return the OperationContractInner object itself.
     */
    public OperationContractInner withTemplateParameters(List<ParameterContract> templateParameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationContractProperties();
        }
        this.innerProperties().withTemplateParameters(templateParameters);
        return this;
    }

    /**
     * Get the description property: Description of the operation. May include HTML formatting tags.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Description of the operation. May include HTML formatting tags.
     * 
     * @param description the description value to set.
     * @return the OperationContractInner object itself.
     */
    public OperationContractInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationContractProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the request property: An entity containing request details.
     * 
     * @return the request value.
     */
    public RequestContract request() {
        return this.innerProperties() == null ? null : this.innerProperties().request();
    }

    /**
     * Set the request property: An entity containing request details.
     * 
     * @param request the request value to set.
     * @return the OperationContractInner object itself.
     */
    public OperationContractInner withRequest(RequestContract request) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationContractProperties();
        }
        this.innerProperties().withRequest(request);
        return this;
    }

    /**
     * Get the responses property: Array of Operation responses.
     * 
     * @return the responses value.
     */
    public List<ResponseContract> responses() {
        return this.innerProperties() == null ? null : this.innerProperties().responses();
    }

    /**
     * Set the responses property: Array of Operation responses.
     * 
     * @param responses the responses value to set.
     * @return the OperationContractInner object itself.
     */
    public OperationContractInner withResponses(List<ResponseContract> responses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationContractProperties();
        }
        this.innerProperties().withResponses(responses);
        return this;
    }

    /**
     * Get the policies property: Operation Policies.
     * 
     * @return the policies value.
     */
    public String policies() {
        return this.innerProperties() == null ? null : this.innerProperties().policies();
    }

    /**
     * Set the policies property: Operation Policies.
     * 
     * @param policies the policies value to set.
     * @return the OperationContractInner object itself.
     */
    public OperationContractInner withPolicies(String policies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationContractProperties();
        }
        this.innerProperties().withPolicies(policies);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperationContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperationContractInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OperationContractInner.
     */
    public static OperationContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationContractInner deserializedOperationContractInner = new OperationContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedOperationContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedOperationContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedOperationContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedOperationContractInner.innerProperties = OperationContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperationContractInner;
        });
    }
}
