// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.AsyncOperationStatus;
import com.azure.resourcemanager.apimanagement.models.ErrorResponseBody;
import com.azure.resourcemanager.apimanagement.models.OperationResultLogItemContract;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Long Running Git Operation Results.
 */
@Fluent
public final class OperationResultContractInner extends ProxyResource {
    /*
     * Properties of the Operation Contract.
     */
    private OperationResultContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of OperationResultContractInner class.
     */
    public OperationResultContractInner() {
    }

    /**
     * Get the innerProperties property: Properties of the Operation Contract.
     * 
     * @return the innerProperties value.
     */
    private OperationResultContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the id property: Operation result identifier.
     * 
     * @return the id value.
     */
    public String idPropertiesId() {
        return this.innerProperties() == null ? null : this.innerProperties().id();
    }

    /**
     * Set the id property: Operation result identifier.
     * 
     * @param id the id value to set.
     * @return the OperationResultContractInner object itself.
     */
    public OperationResultContractInner withIdPropertiesId(String id) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationResultContractProperties();
        }
        this.innerProperties().withId(id);
        return this;
    }

    /**
     * Get the status property: Status of an async operation.
     * 
     * @return the status value.
     */
    public AsyncOperationStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Set the status property: Status of an async operation.
     * 
     * @param status the status value to set.
     * @return the OperationResultContractInner object itself.
     */
    public OperationResultContractInner withStatus(AsyncOperationStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationResultContractProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    /**
     * Get the started property: Start time of an async operation. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the started value.
     */
    public OffsetDateTime started() {
        return this.innerProperties() == null ? null : this.innerProperties().started();
    }

    /**
     * Set the started property: Start time of an async operation. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @param started the started value to set.
     * @return the OperationResultContractInner object itself.
     */
    public OperationResultContractInner withStarted(OffsetDateTime started) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationResultContractProperties();
        }
        this.innerProperties().withStarted(started);
        return this;
    }

    /**
     * Get the updated property: Last update time of an async operation. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the updated value.
     */
    public OffsetDateTime updated() {
        return this.innerProperties() == null ? null : this.innerProperties().updated();
    }

    /**
     * Set the updated property: Last update time of an async operation. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @param updated the updated value to set.
     * @return the OperationResultContractInner object itself.
     */
    public OperationResultContractInner withUpdated(OffsetDateTime updated) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationResultContractProperties();
        }
        this.innerProperties().withUpdated(updated);
        return this;
    }

    /**
     * Get the resultInfo property: Optional result info.
     * 
     * @return the resultInfo value.
     */
    public String resultInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().resultInfo();
    }

    /**
     * Set the resultInfo property: Optional result info.
     * 
     * @param resultInfo the resultInfo value to set.
     * @return the OperationResultContractInner object itself.
     */
    public OperationResultContractInner withResultInfo(String resultInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationResultContractProperties();
        }
        this.innerProperties().withResultInfo(resultInfo);
        return this;
    }

    /**
     * Get the error property: Error Body Contract.
     * 
     * @return the error value.
     */
    public ErrorResponseBody error() {
        return this.innerProperties() == null ? null : this.innerProperties().error();
    }

    /**
     * Set the error property: Error Body Contract.
     * 
     * @param error the error value to set.
     * @return the OperationResultContractInner object itself.
     */
    public OperationResultContractInner withError(ErrorResponseBody error) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationResultContractProperties();
        }
        this.innerProperties().withError(error);
        return this;
    }

    /**
     * Get the actionLog property: This property if only provided as part of the TenantConfiguration_Validate operation.
     * It contains the log the entities which will be updated/created/deleted as part of the TenantConfiguration_Deploy
     * operation.
     * 
     * @return the actionLog value.
     */
    public List<OperationResultLogItemContract> actionLog() {
        return this.innerProperties() == null ? null : this.innerProperties().actionLog();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperationResultContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperationResultContractInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OperationResultContractInner.
     */
    public static OperationResultContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationResultContractInner deserializedOperationResultContractInner = new OperationResultContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedOperationResultContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedOperationResultContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedOperationResultContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedOperationResultContractInner.innerProperties
                        = OperationResultContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperationResultContractInner;
        });
    }
}
