// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.AsyncOperationStatus;
import com.azure.resourcemanager.apimanagement.models.ErrorResponseBody;
import com.azure.resourcemanager.apimanagement.models.OperationResultLogItemContract;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Operation Result.
 */
@Fluent
public final class OperationResultContractProperties implements JsonSerializable<OperationResultContractProperties> {
    /*
     * Operation result identifier.
     */
    private String id;

    /*
     * Status of an async operation.
     */
    private AsyncOperationStatus status;

    /*
     * Start time of an async operation. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified
     * by the ISO 8601 standard.
     */
    private OffsetDateTime started;

    /*
     * Last update time of an async operation. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as
     * specified by the ISO 8601 standard.
     */
    private OffsetDateTime updated;

    /*
     * Optional result info.
     */
    private String resultInfo;

    /*
     * Error Body Contract
     */
    private ErrorResponseBody error;

    /*
     * This property if only provided as part of the TenantConfiguration_Validate operation. It contains the log the
     * entities which will be updated/created/deleted as part of the TenantConfiguration_Deploy operation.
     */
    private List<OperationResultLogItemContract> actionLog;

    /**
     * Creates an instance of OperationResultContractProperties class.
     */
    public OperationResultContractProperties() {
    }

    /**
     * Get the id property: Operation result identifier.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Operation result identifier.
     * 
     * @param id the id value to set.
     * @return the OperationResultContractProperties object itself.
     */
    public OperationResultContractProperties withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the status property: Status of an async operation.
     * 
     * @return the status value.
     */
    public AsyncOperationStatus status() {
        return this.status;
    }

    /**
     * Set the status property: Status of an async operation.
     * 
     * @param status the status value to set.
     * @return the OperationResultContractProperties object itself.
     */
    public OperationResultContractProperties withStatus(AsyncOperationStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the started property: Start time of an async operation. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the started value.
     */
    public OffsetDateTime started() {
        return this.started;
    }

    /**
     * Set the started property: Start time of an async operation. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @param started the started value to set.
     * @return the OperationResultContractProperties object itself.
     */
    public OperationResultContractProperties withStarted(OffsetDateTime started) {
        this.started = started;
        return this;
    }

    /**
     * Get the updated property: Last update time of an async operation. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the updated value.
     */
    public OffsetDateTime updated() {
        return this.updated;
    }

    /**
     * Set the updated property: Last update time of an async operation. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @param updated the updated value to set.
     * @return the OperationResultContractProperties object itself.
     */
    public OperationResultContractProperties withUpdated(OffsetDateTime updated) {
        this.updated = updated;
        return this;
    }

    /**
     * Get the resultInfo property: Optional result info.
     * 
     * @return the resultInfo value.
     */
    public String resultInfo() {
        return this.resultInfo;
    }

    /**
     * Set the resultInfo property: Optional result info.
     * 
     * @param resultInfo the resultInfo value to set.
     * @return the OperationResultContractProperties object itself.
     */
    public OperationResultContractProperties withResultInfo(String resultInfo) {
        this.resultInfo = resultInfo;
        return this;
    }

    /**
     * Get the error property: Error Body Contract.
     * 
     * @return the error value.
     */
    public ErrorResponseBody error() {
        return this.error;
    }

    /**
     * Set the error property: Error Body Contract.
     * 
     * @param error the error value to set.
     * @return the OperationResultContractProperties object itself.
     */
    public OperationResultContractProperties withError(ErrorResponseBody error) {
        this.error = error;
        return this;
    }

    /**
     * Get the actionLog property: This property if only provided as part of the TenantConfiguration_Validate operation.
     * It contains the log the entities which will be updated/created/deleted as part of the TenantConfiguration_Deploy
     * operation.
     * 
     * @return the actionLog value.
     */
    public List<OperationResultLogItemContract> actionLog() {
        return this.actionLog;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (error() != null) {
            error().validate();
        }
        if (actionLog() != null) {
            actionLog().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("started",
            this.started == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.started));
        jsonWriter.writeStringField("updated",
            this.updated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updated));
        jsonWriter.writeStringField("resultInfo", this.resultInfo);
        jsonWriter.writeJsonField("error", this.error);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperationResultContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperationResultContractProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OperationResultContractProperties.
     */
    public static OperationResultContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationResultContractProperties deserializedOperationResultContractProperties
                = new OperationResultContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedOperationResultContractProperties.id = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedOperationResultContractProperties.status
                        = AsyncOperationStatus.fromString(reader.getString());
                } else if ("started".equals(fieldName)) {
                    deserializedOperationResultContractProperties.started = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("updated".equals(fieldName)) {
                    deserializedOperationResultContractProperties.updated = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("resultInfo".equals(fieldName)) {
                    deserializedOperationResultContractProperties.resultInfo = reader.getString();
                } else if ("error".equals(fieldName)) {
                    deserializedOperationResultContractProperties.error = ErrorResponseBody.fromJson(reader);
                } else if ("actionLog".equals(fieldName)) {
                    List<OperationResultLogItemContract> actionLog
                        = reader.readArray(reader1 -> OperationResultLogItemContract.fromJson(reader1));
                    deserializedOperationResultContractProperties.actionLog = actionLog;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperationResultContractProperties;
        });
    }
}
