// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.PolicyContentFormat;
import java.io.IOException;

/**
 * Policy contract Properties.
 */
@Fluent
public final class PolicyContractProperties implements JsonSerializable<PolicyContractProperties> {
    /*
     * Contents of the Policy as defined by the format.
     */
    private String value;

    /*
     * Format of the policyContent.
     */
    private PolicyContentFormat format;

    /**
     * Creates an instance of PolicyContractProperties class.
     */
    public PolicyContractProperties() {
    }

    /**
     * Get the value property: Contents of the Policy as defined by the format.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Contents of the Policy as defined by the format.
     * 
     * @param value the value value to set.
     * @return the PolicyContractProperties object itself.
     */
    public PolicyContractProperties withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the format property: Format of the policyContent.
     * 
     * @return the format value.
     */
    public PolicyContentFormat format() {
        return this.format;
    }

    /**
     * Set the format property: Format of the policyContent.
     * 
     * @param format the format value to set.
     * @return the PolicyContractProperties object itself.
     */
    public PolicyContractProperties withFormat(PolicyContentFormat format) {
        this.format = format;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model PolicyContractProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PolicyContractProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("format", this.format == null ? null : this.format.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyContractProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PolicyContractProperties.
     */
    public static PolicyContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyContractProperties deserializedPolicyContractProperties = new PolicyContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedPolicyContractProperties.value = reader.getString();
                } else if ("format".equals(fieldName)) {
                    deserializedPolicyContractProperties.format = PolicyContentFormat.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicyContractProperties;
        });
    }
}
