// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.PolicyFragmentContentFormat;
import java.io.IOException;

/**
 * Policy fragment contract properties.
 */
@Fluent
public final class PolicyFragmentContractProperties implements JsonSerializable<PolicyFragmentContractProperties> {
    /*
     * Contents of the policy fragment.
     */
    private String value;

    /*
     * Policy fragment description.
     */
    private String description;

    /*
     * Format of the policy fragment content.
     */
    private PolicyFragmentContentFormat format;

    /*
     * The provisioning state
     */
    private String provisioningState;

    /**
     * Creates an instance of PolicyFragmentContractProperties class.
     */
    public PolicyFragmentContractProperties() {
    }

    /**
     * Get the value property: Contents of the policy fragment.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Contents of the policy fragment.
     * 
     * @param value the value value to set.
     * @return the PolicyFragmentContractProperties object itself.
     */
    public PolicyFragmentContractProperties withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the description property: Policy fragment description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Policy fragment description.
     * 
     * @param description the description value to set.
     * @return the PolicyFragmentContractProperties object itself.
     */
    public PolicyFragmentContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the format property: Format of the policy fragment content.
     * 
     * @return the format value.
     */
    public PolicyFragmentContentFormat format() {
        return this.format;
    }

    /**
     * Set the format property: Format of the policy fragment content.
     * 
     * @param format the format value to set.
     * @return the PolicyFragmentContractProperties object itself.
     */
    public PolicyFragmentContractProperties withFormat(PolicyFragmentContentFormat format) {
        this.format = format;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property value in model PolicyFragmentContractProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PolicyFragmentContractProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("format", this.format == null ? null : this.format.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyFragmentContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyFragmentContractProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PolicyFragmentContractProperties.
     */
    public static PolicyFragmentContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyFragmentContractProperties deserializedPolicyFragmentContractProperties
                = new PolicyFragmentContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedPolicyFragmentContractProperties.value = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedPolicyFragmentContractProperties.description = reader.getString();
                } else if ("format".equals(fieldName)) {
                    deserializedPolicyFragmentContractProperties.format
                        = PolicyFragmentContentFormat.fromString(reader.getString());
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedPolicyFragmentContractProperties.provisioningState = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicyFragmentContractProperties;
        });
    }
}
