// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionRequireBase;
import java.io.IOException;

/**
 * Policy restriction contract details.
 */
@Fluent
public final class PolicyRestrictionContractInner extends ProxyResource {
    /*
     * Properties of the Policy Restriction.
     */
    private PolicyRestrictionContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of PolicyRestrictionContractInner class.
     */
    public PolicyRestrictionContractInner() {
    }

    /**
     * Get the innerProperties property: Properties of the Policy Restriction.
     * 
     * @return the innerProperties value.
     */
    private PolicyRestrictionContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the scope property: Path to the policy document.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    /**
     * Set the scope property: Path to the policy document.
     * 
     * @param scope the scope value to set.
     * @return the PolicyRestrictionContractInner object itself.
     */
    public PolicyRestrictionContractInner withScope(String scope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyRestrictionContractProperties();
        }
        this.innerProperties().withScope(scope);
        return this;
    }

    /**
     * Get the requireBase property: Indicates if base policy should be enforced for the policy document.
     * 
     * @return the requireBase value.
     */
    public PolicyRestrictionRequireBase requireBase() {
        return this.innerProperties() == null ? null : this.innerProperties().requireBase();
    }

    /**
     * Set the requireBase property: Indicates if base policy should be enforced for the policy document.
     * 
     * @param requireBase the requireBase value to set.
     * @return the PolicyRestrictionContractInner object itself.
     */
    public PolicyRestrictionContractInner withRequireBase(PolicyRestrictionRequireBase requireBase) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyRestrictionContractProperties();
        }
        this.innerProperties().withRequireBase(requireBase);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyRestrictionContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyRestrictionContractInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PolicyRestrictionContractInner.
     */
    public static PolicyRestrictionContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyRestrictionContractInner deserializedPolicyRestrictionContractInner
                = new PolicyRestrictionContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPolicyRestrictionContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedPolicyRestrictionContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPolicyRestrictionContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedPolicyRestrictionContractInner.innerProperties
                        = PolicyRestrictionContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicyRestrictionContractInner;
        });
    }
}
