// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.PolicyRestrictionRequireBase;
import java.io.IOException;

/**
 * Policy restrictions contract properties.
 */
@Fluent
public final class PolicyRestrictionContractProperties
    implements JsonSerializable<PolicyRestrictionContractProperties> {
    /*
     * Path to the policy document.
     */
    private String scope;

    /*
     * Indicates if base policy should be enforced for the policy document.
     */
    private PolicyRestrictionRequireBase requireBase;

    /**
     * Creates an instance of PolicyRestrictionContractProperties class.
     */
    public PolicyRestrictionContractProperties() {
    }

    /**
     * Get the scope property: Path to the policy document.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.scope;
    }

    /**
     * Set the scope property: Path to the policy document.
     * 
     * @param scope the scope value to set.
     * @return the PolicyRestrictionContractProperties object itself.
     */
    public PolicyRestrictionContractProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the requireBase property: Indicates if base policy should be enforced for the policy document.
     * 
     * @return the requireBase value.
     */
    public PolicyRestrictionRequireBase requireBase() {
        return this.requireBase;
    }

    /**
     * Set the requireBase property: Indicates if base policy should be enforced for the policy document.
     * 
     * @param requireBase the requireBase value to set.
     * @return the PolicyRestrictionContractProperties object itself.
     */
    public PolicyRestrictionContractProperties withRequireBase(PolicyRestrictionRequireBase requireBase) {
        this.requireBase = requireBase;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeStringField("requireBase", this.requireBase == null ? null : this.requireBase.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyRestrictionContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyRestrictionContractProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PolicyRestrictionContractProperties.
     */
    public static PolicyRestrictionContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyRestrictionContractProperties deserializedPolicyRestrictionContractProperties
                = new PolicyRestrictionContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scope".equals(fieldName)) {
                    deserializedPolicyRestrictionContractProperties.scope = reader.getString();
                } else if ("requireBase".equals(fieldName)) {
                    deserializedPolicyRestrictionContractProperties.requireBase
                        = PolicyRestrictionRequireBase.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicyRestrictionContractProperties;
        });
    }
}
