// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.PortalConfigCorsProperties;
import com.azure.resourcemanager.apimanagement.models.PortalConfigCspProperties;
import com.azure.resourcemanager.apimanagement.models.PortalConfigDelegationProperties;
import com.azure.resourcemanager.apimanagement.models.PortalConfigPropertiesSignin;
import com.azure.resourcemanager.apimanagement.models.PortalConfigPropertiesSignup;
import java.io.IOException;

/**
 * The developer portal configuration contract properties.
 */
@Fluent
public final class PortalConfigProperties implements JsonSerializable<PortalConfigProperties> {
    /*
     * Enable or disable Basic authentication method.
     */
    private Boolean enableBasicAuth;

    /*
     * The signin property.
     */
    private PortalConfigPropertiesSignin signin;

    /*
     * The signup property.
     */
    private PortalConfigPropertiesSignup signup;

    /*
     * The developer portal delegation settings.
     */
    private PortalConfigDelegationProperties delegation;

    /*
     * The developer portal Cross-Origin Resource Sharing (CORS) settings.
     */
    private PortalConfigCorsProperties cors;

    /*
     * The developer portal Content Security Policy (CSP) settings.
     */
    private PortalConfigCspProperties csp;

    /**
     * Creates an instance of PortalConfigProperties class.
     */
    public PortalConfigProperties() {
    }

    /**
     * Get the enableBasicAuth property: Enable or disable Basic authentication method.
     * 
     * @return the enableBasicAuth value.
     */
    public Boolean enableBasicAuth() {
        return this.enableBasicAuth;
    }

    /**
     * Set the enableBasicAuth property: Enable or disable Basic authentication method.
     * 
     * @param enableBasicAuth the enableBasicAuth value to set.
     * @return the PortalConfigProperties object itself.
     */
    public PortalConfigProperties withEnableBasicAuth(Boolean enableBasicAuth) {
        this.enableBasicAuth = enableBasicAuth;
        return this;
    }

    /**
     * Get the signin property: The signin property.
     * 
     * @return the signin value.
     */
    public PortalConfigPropertiesSignin signin() {
        return this.signin;
    }

    /**
     * Set the signin property: The signin property.
     * 
     * @param signin the signin value to set.
     * @return the PortalConfigProperties object itself.
     */
    public PortalConfigProperties withSignin(PortalConfigPropertiesSignin signin) {
        this.signin = signin;
        return this;
    }

    /**
     * Get the signup property: The signup property.
     * 
     * @return the signup value.
     */
    public PortalConfigPropertiesSignup signup() {
        return this.signup;
    }

    /**
     * Set the signup property: The signup property.
     * 
     * @param signup the signup value to set.
     * @return the PortalConfigProperties object itself.
     */
    public PortalConfigProperties withSignup(PortalConfigPropertiesSignup signup) {
        this.signup = signup;
        return this;
    }

    /**
     * Get the delegation property: The developer portal delegation settings.
     * 
     * @return the delegation value.
     */
    public PortalConfigDelegationProperties delegation() {
        return this.delegation;
    }

    /**
     * Set the delegation property: The developer portal delegation settings.
     * 
     * @param delegation the delegation value to set.
     * @return the PortalConfigProperties object itself.
     */
    public PortalConfigProperties withDelegation(PortalConfigDelegationProperties delegation) {
        this.delegation = delegation;
        return this;
    }

    /**
     * Get the cors property: The developer portal Cross-Origin Resource Sharing (CORS) settings.
     * 
     * @return the cors value.
     */
    public PortalConfigCorsProperties cors() {
        return this.cors;
    }

    /**
     * Set the cors property: The developer portal Cross-Origin Resource Sharing (CORS) settings.
     * 
     * @param cors the cors value to set.
     * @return the PortalConfigProperties object itself.
     */
    public PortalConfigProperties withCors(PortalConfigCorsProperties cors) {
        this.cors = cors;
        return this;
    }

    /**
     * Get the csp property: The developer portal Content Security Policy (CSP) settings.
     * 
     * @return the csp value.
     */
    public PortalConfigCspProperties csp() {
        return this.csp;
    }

    /**
     * Set the csp property: The developer portal Content Security Policy (CSP) settings.
     * 
     * @param csp the csp value to set.
     * @return the PortalConfigProperties object itself.
     */
    public PortalConfigProperties withCsp(PortalConfigCspProperties csp) {
        this.csp = csp;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (signin() != null) {
            signin().validate();
        }
        if (signup() != null) {
            signup().validate();
        }
        if (delegation() != null) {
            delegation().validate();
        }
        if (cors() != null) {
            cors().validate();
        }
        if (csp() != null) {
            csp().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enableBasicAuth", this.enableBasicAuth);
        jsonWriter.writeJsonField("signin", this.signin);
        jsonWriter.writeJsonField("signup", this.signup);
        jsonWriter.writeJsonField("delegation", this.delegation);
        jsonWriter.writeJsonField("cors", this.cors);
        jsonWriter.writeJsonField("csp", this.csp);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PortalConfigProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PortalConfigProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PortalConfigProperties.
     */
    public static PortalConfigProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PortalConfigProperties deserializedPortalConfigProperties = new PortalConfigProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enableBasicAuth".equals(fieldName)) {
                    deserializedPortalConfigProperties.enableBasicAuth = reader.getNullable(JsonReader::getBoolean);
                } else if ("signin".equals(fieldName)) {
                    deserializedPortalConfigProperties.signin = PortalConfigPropertiesSignin.fromJson(reader);
                } else if ("signup".equals(fieldName)) {
                    deserializedPortalConfigProperties.signup = PortalConfigPropertiesSignup.fromJson(reader);
                } else if ("delegation".equals(fieldName)) {
                    deserializedPortalConfigProperties.delegation = PortalConfigDelegationProperties.fromJson(reader);
                } else if ("cors".equals(fieldName)) {
                    deserializedPortalConfigProperties.cors = PortalConfigCorsProperties.fromJson(reader);
                } else if ("csp".equals(fieldName)) {
                    deserializedPortalConfigProperties.csp = PortalConfigCspProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPortalConfigProperties;
        });
    }
}
