// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.RegistrationDelegationSettingsProperties;
import com.azure.resourcemanager.apimanagement.models.SubscriptionsDelegationSettingsProperties;
import java.io.IOException;

/**
 * Delegation settings for a developer portal.
 */
@Fluent
public final class PortalDelegationSettingsInner extends ProxyResource {
    /*
     * Delegation settings contract properties.
     */
    private PortalDelegationSettingsProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of PortalDelegationSettingsInner class.
     */
    public PortalDelegationSettingsInner() {
    }

    /**
     * Get the innerProperties property: Delegation settings contract properties.
     * 
     * @return the innerProperties value.
     */
    private PortalDelegationSettingsProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the url property: A delegation Url.
     * 
     * @return the url value.
     */
    public String url() {
        return this.innerProperties() == null ? null : this.innerProperties().url();
    }

    /**
     * Set the url property: A delegation Url.
     * 
     * @param url the url value to set.
     * @return the PortalDelegationSettingsInner object itself.
     */
    public PortalDelegationSettingsInner withUrl(String url) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalDelegationSettingsProperties();
        }
        this.innerProperties().withUrl(url);
        return this;
    }

    /**
     * Get the validationKey property: A base64-encoded validation key to validate, that a request is coming from Azure
     * API Management.
     * 
     * @return the validationKey value.
     */
    public String validationKey() {
        return this.innerProperties() == null ? null : this.innerProperties().validationKey();
    }

    /**
     * Set the validationKey property: A base64-encoded validation key to validate, that a request is coming from Azure
     * API Management.
     * 
     * @param validationKey the validationKey value to set.
     * @return the PortalDelegationSettingsInner object itself.
     */
    public PortalDelegationSettingsInner withValidationKey(String validationKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalDelegationSettingsProperties();
        }
        this.innerProperties().withValidationKey(validationKey);
        return this;
    }

    /**
     * Get the subscriptions property: Subscriptions delegation settings.
     * 
     * @return the subscriptions value.
     */
    public SubscriptionsDelegationSettingsProperties subscriptions() {
        return this.innerProperties() == null ? null : this.innerProperties().subscriptions();
    }

    /**
     * Set the subscriptions property: Subscriptions delegation settings.
     * 
     * @param subscriptions the subscriptions value to set.
     * @return the PortalDelegationSettingsInner object itself.
     */
    public PortalDelegationSettingsInner withSubscriptions(SubscriptionsDelegationSettingsProperties subscriptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalDelegationSettingsProperties();
        }
        this.innerProperties().withSubscriptions(subscriptions);
        return this;
    }

    /**
     * Get the userRegistration property: User registration delegation settings.
     * 
     * @return the userRegistration value.
     */
    public RegistrationDelegationSettingsProperties userRegistration() {
        return this.innerProperties() == null ? null : this.innerProperties().userRegistration();
    }

    /**
     * Set the userRegistration property: User registration delegation settings.
     * 
     * @param userRegistration the userRegistration value to set.
     * @return the PortalDelegationSettingsInner object itself.
     */
    public PortalDelegationSettingsInner
        withUserRegistration(RegistrationDelegationSettingsProperties userRegistration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalDelegationSettingsProperties();
        }
        this.innerProperties().withUserRegistration(userRegistration);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PortalDelegationSettingsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PortalDelegationSettingsInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PortalDelegationSettingsInner.
     */
    public static PortalDelegationSettingsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PortalDelegationSettingsInner deserializedPortalDelegationSettingsInner
                = new PortalDelegationSettingsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPortalDelegationSettingsInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedPortalDelegationSettingsInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPortalDelegationSettingsInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedPortalDelegationSettingsInner.innerProperties
                        = PortalDelegationSettingsProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPortalDelegationSettingsInner;
        });
    }
}
