// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.PortalRevisionStatus;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The PortalRevisionContractProperties model.
 */
@Fluent
public final class PortalRevisionContractProperties implements JsonSerializable<PortalRevisionContractProperties> {
    /*
     * Portal revision description.
     */
    private String description;

    /*
     * Portal revision publishing status details.
     */
    private String statusDetails;

    /*
     * Status of the portal's revision.
     */
    private PortalRevisionStatus status;

    /*
     * Indicates if the portal's revision is public.
     */
    private Boolean isCurrent;

    /*
     * Portal's revision creation date and time.
     */
    private OffsetDateTime createdDateTime;

    /*
     * Last updated date and time.
     */
    private OffsetDateTime updatedDateTime;

    /*
     * The provisioning state
     */
    private String provisioningState;

    /**
     * Creates an instance of PortalRevisionContractProperties class.
     */
    public PortalRevisionContractProperties() {
    }

    /**
     * Get the description property: Portal revision description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Portal revision description.
     * 
     * @param description the description value to set.
     * @return the PortalRevisionContractProperties object itself.
     */
    public PortalRevisionContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the statusDetails property: Portal revision publishing status details.
     * 
     * @return the statusDetails value.
     */
    public String statusDetails() {
        return this.statusDetails;
    }

    /**
     * Get the status property: Status of the portal's revision.
     * 
     * @return the status value.
     */
    public PortalRevisionStatus status() {
        return this.status;
    }

    /**
     * Get the isCurrent property: Indicates if the portal's revision is public.
     * 
     * @return the isCurrent value.
     */
    public Boolean isCurrent() {
        return this.isCurrent;
    }

    /**
     * Set the isCurrent property: Indicates if the portal's revision is public.
     * 
     * @param isCurrent the isCurrent value to set.
     * @return the PortalRevisionContractProperties object itself.
     */
    public PortalRevisionContractProperties withIsCurrent(Boolean isCurrent) {
        this.isCurrent = isCurrent;
        return this;
    }

    /**
     * Get the createdDateTime property: Portal's revision creation date and time.
     * 
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Get the updatedDateTime property: Last updated date and time.
     * 
     * @return the updatedDateTime value.
     */
    public OffsetDateTime updatedDateTime() {
        return this.updatedDateTime;
    }

    /**
     * Get the provisioningState property: The provisioning state.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeBooleanField("isCurrent", this.isCurrent);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PortalRevisionContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PortalRevisionContractProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PortalRevisionContractProperties.
     */
    public static PortalRevisionContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PortalRevisionContractProperties deserializedPortalRevisionContractProperties
                = new PortalRevisionContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedPortalRevisionContractProperties.description = reader.getString();
                } else if ("statusDetails".equals(fieldName)) {
                    deserializedPortalRevisionContractProperties.statusDetails = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedPortalRevisionContractProperties.status
                        = PortalRevisionStatus.fromString(reader.getString());
                } else if ("isCurrent".equals(fieldName)) {
                    deserializedPortalRevisionContractProperties.isCurrent = reader.getNullable(JsonReader::getBoolean);
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedPortalRevisionContractProperties.createdDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("updatedDateTime".equals(fieldName)) {
                    deserializedPortalRevisionContractProperties.updatedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedPortalRevisionContractProperties.provisioningState = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPortalRevisionContractProperties;
        });
    }
}
