// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
 */
@Fluent
public final class PortalSettingValidationKeyContractInner
    implements JsonSerializable<PortalSettingValidationKeyContractInner> {
    /*
     * This is secret value of the validation key in portal settings.
     */
    private String validationKey;

    /**
     * Creates an instance of PortalSettingValidationKeyContractInner class.
     */
    public PortalSettingValidationKeyContractInner() {
    }

    /**
     * Get the validationKey property: This is secret value of the validation key in portal settings.
     * 
     * @return the validationKey value.
     */
    public String validationKey() {
        return this.validationKey;
    }

    /**
     * Set the validationKey property: This is secret value of the validation key in portal settings.
     * 
     * @param validationKey the validationKey value to set.
     * @return the PortalSettingValidationKeyContractInner object itself.
     */
    public PortalSettingValidationKeyContractInner withValidationKey(String validationKey) {
        this.validationKey = validationKey;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("validationKey", this.validationKey);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PortalSettingValidationKeyContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PortalSettingValidationKeyContractInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PortalSettingValidationKeyContractInner.
     */
    public static PortalSettingValidationKeyContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PortalSettingValidationKeyContractInner deserializedPortalSettingValidationKeyContractInner
                = new PortalSettingValidationKeyContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("validationKey".equals(fieldName)) {
                    deserializedPortalSettingValidationKeyContractInner.validationKey = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPortalSettingValidationKeyContractInner;
        });
    }
}
