// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Sign-in settings contract properties.
 */
@Fluent
public final class PortalSigninSettingProperties implements JsonSerializable<PortalSigninSettingProperties> {
    /*
     * Redirect Anonymous users to the Sign-In page.
     */
    private Boolean enabled;

    /**
     * Creates an instance of PortalSigninSettingProperties class.
     */
    public PortalSigninSettingProperties() {
    }

    /**
     * Get the enabled property: Redirect Anonymous users to the Sign-In page.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Redirect Anonymous users to the Sign-In page.
     * 
     * @param enabled the enabled value to set.
     * @return the PortalSigninSettingProperties object itself.
     */
    public PortalSigninSettingProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PortalSigninSettingProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PortalSigninSettingProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PortalSigninSettingProperties.
     */
    public static PortalSigninSettingProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PortalSigninSettingProperties deserializedPortalSigninSettingProperties
                = new PortalSigninSettingProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedPortalSigninSettingProperties.enabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPortalSigninSettingProperties;
        });
    }
}
