// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Sign-In settings for the Developer Portal.
 */
@Fluent
public final class PortalSigninSettingsInner extends ProxyResource {
    /*
     * Sign-in settings contract properties.
     */
    private PortalSigninSettingProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of PortalSigninSettingsInner class.
     */
    public PortalSigninSettingsInner() {
    }

    /**
     * Get the innerProperties property: Sign-in settings contract properties.
     * 
     * @return the innerProperties value.
     */
    private PortalSigninSettingProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the enabled property: Redirect Anonymous users to the Sign-In page.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    /**
     * Set the enabled property: Redirect Anonymous users to the Sign-In page.
     * 
     * @param enabled the enabled value to set.
     * @return the PortalSigninSettingsInner object itself.
     */
    public PortalSigninSettingsInner withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalSigninSettingProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PortalSigninSettingsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PortalSigninSettingsInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PortalSigninSettingsInner.
     */
    public static PortalSigninSettingsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PortalSigninSettingsInner deserializedPortalSigninSettingsInner = new PortalSigninSettingsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPortalSigninSettingsInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedPortalSigninSettingsInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPortalSigninSettingsInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedPortalSigninSettingsInner.innerProperties
                        = PortalSigninSettingProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPortalSigninSettingsInner;
        });
    }
}
