// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.TermsOfServiceProperties;
import java.io.IOException;

/**
 * Sign-Up settings for a developer portal.
 */
@Fluent
public final class PortalSignupSettingsInner extends ProxyResource {
    /*
     * Sign-up settings contract properties.
     */
    private PortalSignupSettingsProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of PortalSignupSettingsInner class.
     */
    public PortalSignupSettingsInner() {
    }

    /**
     * Get the innerProperties property: Sign-up settings contract properties.
     * 
     * @return the innerProperties value.
     */
    private PortalSignupSettingsProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the enabled property: Allow users to sign up on a developer portal.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    /**
     * Set the enabled property: Allow users to sign up on a developer portal.
     * 
     * @param enabled the enabled value to set.
     * @return the PortalSignupSettingsInner object itself.
     */
    public PortalSignupSettingsInner withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalSignupSettingsProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    /**
     * Get the termsOfService property: Terms of service contract properties.
     * 
     * @return the termsOfService value.
     */
    public TermsOfServiceProperties termsOfService() {
        return this.innerProperties() == null ? null : this.innerProperties().termsOfService();
    }

    /**
     * Set the termsOfService property: Terms of service contract properties.
     * 
     * @param termsOfService the termsOfService value to set.
     * @return the PortalSignupSettingsInner object itself.
     */
    public PortalSignupSettingsInner withTermsOfService(TermsOfServiceProperties termsOfService) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalSignupSettingsProperties();
        }
        this.innerProperties().withTermsOfService(termsOfService);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PortalSignupSettingsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PortalSignupSettingsInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PortalSignupSettingsInner.
     */
    public static PortalSignupSettingsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PortalSignupSettingsInner deserializedPortalSignupSettingsInner = new PortalSignupSettingsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPortalSignupSettingsInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedPortalSignupSettingsInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPortalSignupSettingsInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedPortalSignupSettingsInner.innerProperties
                        = PortalSignupSettingsProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPortalSignupSettingsInner;
        });
    }
}
