// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.TermsOfServiceProperties;
import java.io.IOException;

/**
 * Sign-up settings contract properties.
 */
@Fluent
public final class PortalSignupSettingsProperties implements JsonSerializable<PortalSignupSettingsProperties> {
    /*
     * Allow users to sign up on a developer portal.
     */
    private Boolean enabled;

    /*
     * Terms of service contract properties.
     */
    private TermsOfServiceProperties termsOfService;

    /**
     * Creates an instance of PortalSignupSettingsProperties class.
     */
    public PortalSignupSettingsProperties() {
    }

    /**
     * Get the enabled property: Allow users to sign up on a developer portal.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Allow users to sign up on a developer portal.
     * 
     * @param enabled the enabled value to set.
     * @return the PortalSignupSettingsProperties object itself.
     */
    public PortalSignupSettingsProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the termsOfService property: Terms of service contract properties.
     * 
     * @return the termsOfService value.
     */
    public TermsOfServiceProperties termsOfService() {
        return this.termsOfService;
    }

    /**
     * Set the termsOfService property: Terms of service contract properties.
     * 
     * @param termsOfService the termsOfService value to set.
     * @return the PortalSignupSettingsProperties object itself.
     */
    public PortalSignupSettingsProperties withTermsOfService(TermsOfServiceProperties termsOfService) {
        this.termsOfService = termsOfService;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (termsOfService() != null) {
            termsOfService().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeJsonField("termsOfService", this.termsOfService);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PortalSignupSettingsProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PortalSignupSettingsProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PortalSignupSettingsProperties.
     */
    public static PortalSignupSettingsProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PortalSignupSettingsProperties deserializedPortalSignupSettingsProperties
                = new PortalSignupSettingsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedPortalSignupSettingsProperties.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("termsOfService".equals(fieldName)) {
                    deserializedPortalSignupSettingsProperties.termsOfService
                        = TermsOfServiceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPortalSignupSettingsProperties;
        });
    }
}
