// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Product-API link entity properties.
 */
@Fluent
public final class ProductApiLinkContractProperties implements JsonSerializable<ProductApiLinkContractProperties> {
    /*
     * Full resource Id of an API.
     */
    private String apiId;

    /**
     * Creates an instance of ProductApiLinkContractProperties class.
     */
    public ProductApiLinkContractProperties() {
    }

    /**
     * Get the apiId property: Full resource Id of an API.
     * 
     * @return the apiId value.
     */
    public String apiId() {
        return this.apiId;
    }

    /**
     * Set the apiId property: Full resource Id of an API.
     * 
     * @param apiId the apiId value to set.
     * @return the ProductApiLinkContractProperties object itself.
     */
    public ProductApiLinkContractProperties withApiId(String apiId) {
        this.apiId = apiId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (apiId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property apiId in model ProductApiLinkContractProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ProductApiLinkContractProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("apiId", this.apiId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProductApiLinkContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProductApiLinkContractProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ProductApiLinkContractProperties.
     */
    public static ProductApiLinkContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProductApiLinkContractProperties deserializedProductApiLinkContractProperties
                = new ProductApiLinkContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("apiId".equals(fieldName)) {
                    deserializedProductApiLinkContractProperties.apiId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProductApiLinkContractProperties;
        });
    }
}
