// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Product-group link details.
 */
@Fluent
public final class ProductGroupLinkContractInner extends ProxyResource {
    /*
     * Product-group link entity contract properties.
     */
    private ProductGroupLinkContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ProductGroupLinkContractInner class.
     */
    public ProductGroupLinkContractInner() {
    }

    /**
     * Get the innerProperties property: Product-group link entity contract properties.
     * 
     * @return the innerProperties value.
     */
    private ProductGroupLinkContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the groupId property: Full resource Id of a group.
     * 
     * @return the groupId value.
     */
    public String groupId() {
        return this.innerProperties() == null ? null : this.innerProperties().groupId();
    }

    /**
     * Set the groupId property: Full resource Id of a group.
     * 
     * @param groupId the groupId value to set.
     * @return the ProductGroupLinkContractInner object itself.
     */
    public ProductGroupLinkContractInner withGroupId(String groupId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProductGroupLinkContractProperties();
        }
        this.innerProperties().withGroupId(groupId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProductGroupLinkContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProductGroupLinkContractInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ProductGroupLinkContractInner.
     */
    public static ProductGroupLinkContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProductGroupLinkContractInner deserializedProductGroupLinkContractInner
                = new ProductGroupLinkContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedProductGroupLinkContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedProductGroupLinkContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedProductGroupLinkContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedProductGroupLinkContractInner.innerProperties
                        = ProductGroupLinkContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProductGroupLinkContractInner;
        });
    }
}
