// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Quota counter details.
 */
@Fluent
public final class QuotaCounterContractInner implements JsonSerializable<QuotaCounterContractInner> {
    /*
     * The Key value of the Counter. Must not be empty.
     */
    private String counterKey;

    /*
     * Identifier of the Period for which the counter was collected. Must not be empty.
     */
    private String periodKey;

    /*
     * The date of the start of Counter Period. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as
     * specified by the ISO 8601 standard.
     */
    private OffsetDateTime periodStartTime;

    /*
     * The date of the end of Counter Period. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as
     * specified by the ISO 8601 standard.
     */
    private OffsetDateTime periodEndTime;

    /*
     * Quota Value Properties
     */
    private QuotaCounterValueContractProperties value;

    /**
     * Creates an instance of QuotaCounterContractInner class.
     */
    public QuotaCounterContractInner() {
    }

    /**
     * Get the counterKey property: The Key value of the Counter. Must not be empty.
     * 
     * @return the counterKey value.
     */
    public String counterKey() {
        return this.counterKey;
    }

    /**
     * Set the counterKey property: The Key value of the Counter. Must not be empty.
     * 
     * @param counterKey the counterKey value to set.
     * @return the QuotaCounterContractInner object itself.
     */
    public QuotaCounterContractInner withCounterKey(String counterKey) {
        this.counterKey = counterKey;
        return this;
    }

    /**
     * Get the periodKey property: Identifier of the Period for which the counter was collected. Must not be empty.
     * 
     * @return the periodKey value.
     */
    public String periodKey() {
        return this.periodKey;
    }

    /**
     * Set the periodKey property: Identifier of the Period for which the counter was collected. Must not be empty.
     * 
     * @param periodKey the periodKey value to set.
     * @return the QuotaCounterContractInner object itself.
     */
    public QuotaCounterContractInner withPeriodKey(String periodKey) {
        this.periodKey = periodKey;
        return this;
    }

    /**
     * Get the periodStartTime property: The date of the start of Counter Period. The date conforms to the following
     * format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the periodStartTime value.
     */
    public OffsetDateTime periodStartTime() {
        return this.periodStartTime;
    }

    /**
     * Set the periodStartTime property: The date of the start of Counter Period. The date conforms to the following
     * format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @param periodStartTime the periodStartTime value to set.
     * @return the QuotaCounterContractInner object itself.
     */
    public QuotaCounterContractInner withPeriodStartTime(OffsetDateTime periodStartTime) {
        this.periodStartTime = periodStartTime;
        return this;
    }

    /**
     * Get the periodEndTime property: The date of the end of Counter Period. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the periodEndTime value.
     */
    public OffsetDateTime periodEndTime() {
        return this.periodEndTime;
    }

    /**
     * Set the periodEndTime property: The date of the end of Counter Period. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @param periodEndTime the periodEndTime value to set.
     * @return the QuotaCounterContractInner object itself.
     */
    public QuotaCounterContractInner withPeriodEndTime(OffsetDateTime periodEndTime) {
        this.periodEndTime = periodEndTime;
        return this;
    }

    /**
     * Get the value property: Quota Value Properties.
     * 
     * @return the value value.
     */
    public QuotaCounterValueContractProperties value() {
        return this.value;
    }

    /**
     * Set the value property: Quota Value Properties.
     * 
     * @param value the value value to set.
     * @return the QuotaCounterContractInner object itself.
     */
    public QuotaCounterContractInner withValue(QuotaCounterValueContractProperties value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (counterKey() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property counterKey in model QuotaCounterContractInner"));
        }
        if (periodKey() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property periodKey in model QuotaCounterContractInner"));
        }
        if (periodStartTime() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property periodStartTime in model QuotaCounterContractInner"));
        }
        if (periodEndTime() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property periodEndTime in model QuotaCounterContractInner"));
        }
        if (value() != null) {
            value().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(QuotaCounterContractInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("counterKey", this.counterKey);
        jsonWriter.writeStringField("periodKey", this.periodKey);
        jsonWriter.writeStringField("periodStartTime",
            this.periodStartTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.periodStartTime));
        jsonWriter.writeStringField("periodEndTime",
            this.periodEndTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.periodEndTime));
        jsonWriter.writeJsonField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QuotaCounterContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QuotaCounterContractInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the QuotaCounterContractInner.
     */
    public static QuotaCounterContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QuotaCounterContractInner deserializedQuotaCounterContractInner = new QuotaCounterContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("counterKey".equals(fieldName)) {
                    deserializedQuotaCounterContractInner.counterKey = reader.getString();
                } else if ("periodKey".equals(fieldName)) {
                    deserializedQuotaCounterContractInner.periodKey = reader.getString();
                } else if ("periodStartTime".equals(fieldName)) {
                    deserializedQuotaCounterContractInner.periodStartTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("periodEndTime".equals(fieldName)) {
                    deserializedQuotaCounterContractInner.periodEndTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("value".equals(fieldName)) {
                    deserializedQuotaCounterContractInner.value = QuotaCounterValueContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQuotaCounterContractInner;
        });
    }
}
