// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Quota counter value details.
 */
@Fluent
public final class QuotaCounterValueContractProperties
    implements JsonSerializable<QuotaCounterValueContractProperties> {
    /*
     * Number of times Counter was called.
     */
    private Integer callsCount;

    /*
     * Data Transferred in KiloBytes.
     */
    private Double kbTransferred;

    /**
     * Creates an instance of QuotaCounterValueContractProperties class.
     */
    public QuotaCounterValueContractProperties() {
    }

    /**
     * Get the callsCount property: Number of times Counter was called.
     * 
     * @return the callsCount value.
     */
    public Integer callsCount() {
        return this.callsCount;
    }

    /**
     * Set the callsCount property: Number of times Counter was called.
     * 
     * @param callsCount the callsCount value to set.
     * @return the QuotaCounterValueContractProperties object itself.
     */
    public QuotaCounterValueContractProperties withCallsCount(Integer callsCount) {
        this.callsCount = callsCount;
        return this;
    }

    /**
     * Get the kbTransferred property: Data Transferred in KiloBytes.
     * 
     * @return the kbTransferred value.
     */
    public Double kbTransferred() {
        return this.kbTransferred;
    }

    /**
     * Set the kbTransferred property: Data Transferred in KiloBytes.
     * 
     * @param kbTransferred the kbTransferred value to set.
     * @return the QuotaCounterValueContractProperties object itself.
     */
    public QuotaCounterValueContractProperties withKbTransferred(Double kbTransferred) {
        this.kbTransferred = kbTransferred;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("callsCount", this.callsCount);
        jsonWriter.writeNumberField("kbTransferred", this.kbTransferred);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QuotaCounterValueContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QuotaCounterValueContractProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the QuotaCounterValueContractProperties.
     */
    public static QuotaCounterValueContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QuotaCounterValueContractProperties deserializedQuotaCounterValueContractProperties
                = new QuotaCounterValueContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("callsCount".equals(fieldName)) {
                    deserializedQuotaCounterValueContractProperties.callsCount = reader.getNullable(JsonReader::getInt);
                } else if ("kbTransferred".equals(fieldName)) {
                    deserializedQuotaCounterValueContractProperties.kbTransferred
                        = reader.getNullable(JsonReader::getDouble);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQuotaCounterValueContractProperties;
        });
    }
}
