// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Recipient Email details.
 */
@Fluent
public final class RecipientEmailContractInner extends ProxyResource {
    /*
     * Recipient Email contract properties.
     */
    private RecipientEmailContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of RecipientEmailContractInner class.
     */
    public RecipientEmailContractInner() {
    }

    /**
     * Get the innerProperties property: Recipient Email contract properties.
     * 
     * @return the innerProperties value.
     */
    private RecipientEmailContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the email property: User Email subscribed to notification.
     * 
     * @return the email value.
     */
    public String email() {
        return this.innerProperties() == null ? null : this.innerProperties().email();
    }

    /**
     * Set the email property: User Email subscribed to notification.
     * 
     * @param email the email value to set.
     * @return the RecipientEmailContractInner object itself.
     */
    public RecipientEmailContractInner withEmail(String email) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecipientEmailContractProperties();
        }
        this.innerProperties().withEmail(email);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecipientEmailContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecipientEmailContractInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RecipientEmailContractInner.
     */
    public static RecipientEmailContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecipientEmailContractInner deserializedRecipientEmailContractInner = new RecipientEmailContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRecipientEmailContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRecipientEmailContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRecipientEmailContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedRecipientEmailContractInner.innerProperties
                        = RecipientEmailContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecipientEmailContractInner;
        });
    }
}
