// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Recipient Email Contract Properties.
 */
@Fluent
public final class RecipientEmailContractProperties implements JsonSerializable<RecipientEmailContractProperties> {
    /*
     * User Email subscribed to notification.
     */
    private String email;

    /**
     * Creates an instance of RecipientEmailContractProperties class.
     */
    public RecipientEmailContractProperties() {
    }

    /**
     * Get the email property: User Email subscribed to notification.
     * 
     * @return the email value.
     */
    public String email() {
        return this.email;
    }

    /**
     * Set the email property: User Email subscribed to notification.
     * 
     * @param email the email value to set.
     * @return the RecipientEmailContractProperties object itself.
     */
    public RecipientEmailContractProperties withEmail(String email) {
        this.email = email;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("email", this.email);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecipientEmailContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecipientEmailContractProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RecipientEmailContractProperties.
     */
    public static RecipientEmailContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecipientEmailContractProperties deserializedRecipientEmailContractProperties
                = new RecipientEmailContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("email".equals(fieldName)) {
                    deserializedRecipientEmailContractProperties.email = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecipientEmailContractProperties;
        });
    }
}
