// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Recipient User details.
 */
@Fluent
public final class RecipientUserContractInner extends ProxyResource {
    /*
     * Recipient User entity contract properties.
     */
    private RecipientUsersContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of RecipientUserContractInner class.
     */
    public RecipientUserContractInner() {
    }

    /**
     * Get the innerProperties property: Recipient User entity contract properties.
     * 
     * @return the innerProperties value.
     */
    private RecipientUsersContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the userId property: API Management UserId subscribed to notification.
     * 
     * @return the userId value.
     */
    public String userId() {
        return this.innerProperties() == null ? null : this.innerProperties().userId();
    }

    /**
     * Set the userId property: API Management UserId subscribed to notification.
     * 
     * @param userId the userId value to set.
     * @return the RecipientUserContractInner object itself.
     */
    public RecipientUserContractInner withUserId(String userId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecipientUsersContractProperties();
        }
        this.innerProperties().withUserId(userId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecipientUserContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecipientUserContractInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RecipientUserContractInner.
     */
    public static RecipientUserContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecipientUserContractInner deserializedRecipientUserContractInner = new RecipientUserContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRecipientUserContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRecipientUserContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRecipientUserContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedRecipientUserContractInner.innerProperties
                        = RecipientUsersContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecipientUserContractInner;
        });
    }
}
