// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Recipient User Contract Properties.
 */
@Fluent
public final class RecipientUsersContractProperties implements JsonSerializable<RecipientUsersContractProperties> {
    /*
     * API Management UserId subscribed to notification.
     */
    private String userId;

    /**
     * Creates an instance of RecipientUsersContractProperties class.
     */
    public RecipientUsersContractProperties() {
    }

    /**
     * Get the userId property: API Management UserId subscribed to notification.
     * 
     * @return the userId value.
     */
    public String userId() {
        return this.userId;
    }

    /**
     * Set the userId property: API Management UserId subscribed to notification.
     * 
     * @param userId the userId value to set.
     * @return the RecipientUsersContractProperties object itself.
     */
    public RecipientUsersContractProperties withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userId", this.userId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecipientUsersContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecipientUsersContractProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RecipientUsersContractProperties.
     */
    public static RecipientUsersContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecipientUsersContractProperties deserializedRecipientUsersContractProperties
                = new RecipientUsersContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("userId".equals(fieldName)) {
                    deserializedRecipientUsersContractProperties.userId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecipientUsersContractProperties;
        });
    }
}
