// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Region profile.
 */
@Fluent
public final class RegionContractInner implements JsonSerializable<RegionContractInner> {
    /*
     * Region name.
     */
    private String name;

    /*
     * whether Region is the master region.
     */
    private Boolean isMasterRegion;

    /*
     * whether Region is deleted.
     */
    private Boolean isDeleted;

    /**
     * Creates an instance of RegionContractInner class.
     */
    public RegionContractInner() {
    }

    /**
     * Get the name property: Region name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the isMasterRegion property: whether Region is the master region.
     * 
     * @return the isMasterRegion value.
     */
    public Boolean isMasterRegion() {
        return this.isMasterRegion;
    }

    /**
     * Set the isMasterRegion property: whether Region is the master region.
     * 
     * @param isMasterRegion the isMasterRegion value to set.
     * @return the RegionContractInner object itself.
     */
    public RegionContractInner withIsMasterRegion(Boolean isMasterRegion) {
        this.isMasterRegion = isMasterRegion;
        return this;
    }

    /**
     * Get the isDeleted property: whether Region is deleted.
     * 
     * @return the isDeleted value.
     */
    public Boolean isDeleted() {
        return this.isDeleted;
    }

    /**
     * Set the isDeleted property: whether Region is deleted.
     * 
     * @param isDeleted the isDeleted value to set.
     * @return the RegionContractInner object itself.
     */
    public RegionContractInner withIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isMasterRegion", this.isMasterRegion);
        jsonWriter.writeBooleanField("isDeleted", this.isDeleted);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RegionContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RegionContractInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RegionContractInner.
     */
    public static RegionContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RegionContractInner deserializedRegionContractInner = new RegionContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedRegionContractInner.name = reader.getString();
                } else if ("isMasterRegion".equals(fieldName)) {
                    deserializedRegionContractInner.isMasterRegion = reader.getNullable(JsonReader::getBoolean);
                } else if ("isDeleted".equals(fieldName)) {
                    deserializedRegionContractInner.isDeleted = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRegionContractInner;
        });
    }
}
