// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Report data.
 */
@Fluent
public final class ReportRecordContractInner implements JsonSerializable<ReportRecordContractInner> {
    /*
     * Name depending on report endpoint specifies product, API, operation or developer name.
     */
    private String name;

    /*
     * Start of aggregation period. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by
     * the ISO 8601 standard.
     */
    private OffsetDateTime timestamp;

    /*
     * Length of aggregation period. Interval must be multiple of 15 minutes and may not be zero. The value should be in
     * ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).
     */
    private String interval;

    /*
     * Country to which this record data is related.
     */
    private String country;

    /*
     * Country region to which this record data is related.
     */
    private String region;

    /*
     * Zip code to which this record data is related.
     */
    private String zip;

    /*
     * User identifier path. /users/{userId}
     */
    private String userId;

    /*
     * Product identifier path. /products/{productId}
     */
    private String productId;

    /*
     * API identifier path. /apis/{apiId}
     */
    private String apiId;

    /*
     * Operation identifier path. /apis/{apiId}/operations/{operationId}
     */
    private String operationId;

    /*
     * API region identifier.
     */
    private String apiRegion;

    /*
     * Subscription identifier path. /subscriptions/{subscriptionId}
     */
    private String subscriptionId;

    /*
     * Number of successful calls. This includes calls returning HttpStatusCode <= 301 and HttpStatusCode.NotModified
     * and HttpStatusCode.TemporaryRedirect
     */
    private Integer callCountSuccess;

    /*
     * Number of calls blocked due to invalid credentials. This includes calls returning HttpStatusCode.Unauthorized and
     * HttpStatusCode.Forbidden and HttpStatusCode.TooManyRequests
     */
    private Integer callCountBlocked;

    /*
     * Number of calls failed due to gateway or backend errors. This includes calls returning
     * HttpStatusCode.BadRequest(400) and any Code between HttpStatusCode.InternalServerError (500) and 600
     */
    private Integer callCountFailed;

    /*
     * Number of other calls.
     */
    private Integer callCountOther;

    /*
     * Total number of calls.
     */
    private Integer callCountTotal;

    /*
     * Bandwidth consumed.
     */
    private Long bandwidth;

    /*
     * Number of times when content was served from cache policy.
     */
    private Integer cacheHitCount;

    /*
     * Number of times content was fetched from backend.
     */
    private Integer cacheMissCount;

    /*
     * Average time it took to process request.
     */
    private Double apiTimeAvg;

    /*
     * Minimum time it took to process request.
     */
    private Double apiTimeMin;

    /*
     * Maximum time it took to process request.
     */
    private Double apiTimeMax;

    /*
     * Average time it took to process request on backend.
     */
    private Double serviceTimeAvg;

    /*
     * Minimum time it took to process request on backend.
     */
    private Double serviceTimeMin;

    /*
     * Maximum time it took to process request on backend.
     */
    private Double serviceTimeMax;

    /**
     * Creates an instance of ReportRecordContractInner class.
     */
    public ReportRecordContractInner() {
    }

    /**
     * Get the name property: Name depending on report endpoint specifies product, API, operation or developer name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name depending on report endpoint specifies product, API, operation or developer name.
     * 
     * @param name the name value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the timestamp property: Start of aggregation period. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the timestamp value.
     */
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    /**
     * Set the timestamp property: Start of aggregation period. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @param timestamp the timestamp value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    /**
     * Get the interval property: Length of aggregation period. Interval must be multiple of 15 minutes and may not be
     * zero. The value should be in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).
     * 
     * @return the interval value.
     */
    public String interval() {
        return this.interval;
    }

    /**
     * Set the interval property: Length of aggregation period. Interval must be multiple of 15 minutes and may not be
     * zero. The value should be in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).
     * 
     * @param interval the interval value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withInterval(String interval) {
        this.interval = interval;
        return this;
    }

    /**
     * Get the country property: Country to which this record data is related.
     * 
     * @return the country value.
     */
    public String country() {
        return this.country;
    }

    /**
     * Set the country property: Country to which this record data is related.
     * 
     * @param country the country value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withCountry(String country) {
        this.country = country;
        return this;
    }

    /**
     * Get the region property: Country region to which this record data is related.
     * 
     * @return the region value.
     */
    public String region() {
        return this.region;
    }

    /**
     * Set the region property: Country region to which this record data is related.
     * 
     * @param region the region value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withRegion(String region) {
        this.region = region;
        return this;
    }

    /**
     * Get the zip property: Zip code to which this record data is related.
     * 
     * @return the zip value.
     */
    public String zip() {
        return this.zip;
    }

    /**
     * Set the zip property: Zip code to which this record data is related.
     * 
     * @param zip the zip value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withZip(String zip) {
        this.zip = zip;
        return this;
    }

    /**
     * Get the userId property: User identifier path. /users/{userId}.
     * 
     * @return the userId value.
     */
    public String userId() {
        return this.userId;
    }

    /**
     * Get the productId property: Product identifier path. /products/{productId}.
     * 
     * @return the productId value.
     */
    public String productId() {
        return this.productId;
    }

    /**
     * Get the apiId property: API identifier path. /apis/{apiId}.
     * 
     * @return the apiId value.
     */
    public String apiId() {
        return this.apiId;
    }

    /**
     * Set the apiId property: API identifier path. /apis/{apiId}.
     * 
     * @param apiId the apiId value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withApiId(String apiId) {
        this.apiId = apiId;
        return this;
    }

    /**
     * Get the operationId property: Operation identifier path. /apis/{apiId}/operations/{operationId}.
     * 
     * @return the operationId value.
     */
    public String operationId() {
        return this.operationId;
    }

    /**
     * Set the operationId property: Operation identifier path. /apis/{apiId}/operations/{operationId}.
     * 
     * @param operationId the operationId value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    /**
     * Get the apiRegion property: API region identifier.
     * 
     * @return the apiRegion value.
     */
    public String apiRegion() {
        return this.apiRegion;
    }

    /**
     * Set the apiRegion property: API region identifier.
     * 
     * @param apiRegion the apiRegion value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withApiRegion(String apiRegion) {
        this.apiRegion = apiRegion;
        return this;
    }

    /**
     * Get the subscriptionId property: Subscription identifier path. /subscriptions/{subscriptionId}.
     * 
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Set the subscriptionId property: Subscription identifier path. /subscriptions/{subscriptionId}.
     * 
     * @param subscriptionId the subscriptionId value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    /**
     * Get the callCountSuccess property: Number of successful calls. This includes calls returning HttpStatusCode &lt;=
     * 301 and HttpStatusCode.NotModified and HttpStatusCode.TemporaryRedirect.
     * 
     * @return the callCountSuccess value.
     */
    public Integer callCountSuccess() {
        return this.callCountSuccess;
    }

    /**
     * Set the callCountSuccess property: Number of successful calls. This includes calls returning HttpStatusCode &lt;=
     * 301 and HttpStatusCode.NotModified and HttpStatusCode.TemporaryRedirect.
     * 
     * @param callCountSuccess the callCountSuccess value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withCallCountSuccess(Integer callCountSuccess) {
        this.callCountSuccess = callCountSuccess;
        return this;
    }

    /**
     * Get the callCountBlocked property: Number of calls blocked due to invalid credentials. This includes calls
     * returning HttpStatusCode.Unauthorized and HttpStatusCode.Forbidden and HttpStatusCode.TooManyRequests.
     * 
     * @return the callCountBlocked value.
     */
    public Integer callCountBlocked() {
        return this.callCountBlocked;
    }

    /**
     * Set the callCountBlocked property: Number of calls blocked due to invalid credentials. This includes calls
     * returning HttpStatusCode.Unauthorized and HttpStatusCode.Forbidden and HttpStatusCode.TooManyRequests.
     * 
     * @param callCountBlocked the callCountBlocked value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withCallCountBlocked(Integer callCountBlocked) {
        this.callCountBlocked = callCountBlocked;
        return this;
    }

    /**
     * Get the callCountFailed property: Number of calls failed due to gateway or backend errors. This includes calls
     * returning HttpStatusCode.BadRequest(400) and any Code between HttpStatusCode.InternalServerError (500) and 600.
     * 
     * @return the callCountFailed value.
     */
    public Integer callCountFailed() {
        return this.callCountFailed;
    }

    /**
     * Set the callCountFailed property: Number of calls failed due to gateway or backend errors. This includes calls
     * returning HttpStatusCode.BadRequest(400) and any Code between HttpStatusCode.InternalServerError (500) and 600.
     * 
     * @param callCountFailed the callCountFailed value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withCallCountFailed(Integer callCountFailed) {
        this.callCountFailed = callCountFailed;
        return this;
    }

    /**
     * Get the callCountOther property: Number of other calls.
     * 
     * @return the callCountOther value.
     */
    public Integer callCountOther() {
        return this.callCountOther;
    }

    /**
     * Set the callCountOther property: Number of other calls.
     * 
     * @param callCountOther the callCountOther value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withCallCountOther(Integer callCountOther) {
        this.callCountOther = callCountOther;
        return this;
    }

    /**
     * Get the callCountTotal property: Total number of calls.
     * 
     * @return the callCountTotal value.
     */
    public Integer callCountTotal() {
        return this.callCountTotal;
    }

    /**
     * Set the callCountTotal property: Total number of calls.
     * 
     * @param callCountTotal the callCountTotal value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withCallCountTotal(Integer callCountTotal) {
        this.callCountTotal = callCountTotal;
        return this;
    }

    /**
     * Get the bandwidth property: Bandwidth consumed.
     * 
     * @return the bandwidth value.
     */
    public Long bandwidth() {
        return this.bandwidth;
    }

    /**
     * Set the bandwidth property: Bandwidth consumed.
     * 
     * @param bandwidth the bandwidth value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withBandwidth(Long bandwidth) {
        this.bandwidth = bandwidth;
        return this;
    }

    /**
     * Get the cacheHitCount property: Number of times when content was served from cache policy.
     * 
     * @return the cacheHitCount value.
     */
    public Integer cacheHitCount() {
        return this.cacheHitCount;
    }

    /**
     * Set the cacheHitCount property: Number of times when content was served from cache policy.
     * 
     * @param cacheHitCount the cacheHitCount value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withCacheHitCount(Integer cacheHitCount) {
        this.cacheHitCount = cacheHitCount;
        return this;
    }

    /**
     * Get the cacheMissCount property: Number of times content was fetched from backend.
     * 
     * @return the cacheMissCount value.
     */
    public Integer cacheMissCount() {
        return this.cacheMissCount;
    }

    /**
     * Set the cacheMissCount property: Number of times content was fetched from backend.
     * 
     * @param cacheMissCount the cacheMissCount value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withCacheMissCount(Integer cacheMissCount) {
        this.cacheMissCount = cacheMissCount;
        return this;
    }

    /**
     * Get the apiTimeAvg property: Average time it took to process request.
     * 
     * @return the apiTimeAvg value.
     */
    public Double apiTimeAvg() {
        return this.apiTimeAvg;
    }

    /**
     * Set the apiTimeAvg property: Average time it took to process request.
     * 
     * @param apiTimeAvg the apiTimeAvg value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withApiTimeAvg(Double apiTimeAvg) {
        this.apiTimeAvg = apiTimeAvg;
        return this;
    }

    /**
     * Get the apiTimeMin property: Minimum time it took to process request.
     * 
     * @return the apiTimeMin value.
     */
    public Double apiTimeMin() {
        return this.apiTimeMin;
    }

    /**
     * Set the apiTimeMin property: Minimum time it took to process request.
     * 
     * @param apiTimeMin the apiTimeMin value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withApiTimeMin(Double apiTimeMin) {
        this.apiTimeMin = apiTimeMin;
        return this;
    }

    /**
     * Get the apiTimeMax property: Maximum time it took to process request.
     * 
     * @return the apiTimeMax value.
     */
    public Double apiTimeMax() {
        return this.apiTimeMax;
    }

    /**
     * Set the apiTimeMax property: Maximum time it took to process request.
     * 
     * @param apiTimeMax the apiTimeMax value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withApiTimeMax(Double apiTimeMax) {
        this.apiTimeMax = apiTimeMax;
        return this;
    }

    /**
     * Get the serviceTimeAvg property: Average time it took to process request on backend.
     * 
     * @return the serviceTimeAvg value.
     */
    public Double serviceTimeAvg() {
        return this.serviceTimeAvg;
    }

    /**
     * Set the serviceTimeAvg property: Average time it took to process request on backend.
     * 
     * @param serviceTimeAvg the serviceTimeAvg value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withServiceTimeAvg(Double serviceTimeAvg) {
        this.serviceTimeAvg = serviceTimeAvg;
        return this;
    }

    /**
     * Get the serviceTimeMin property: Minimum time it took to process request on backend.
     * 
     * @return the serviceTimeMin value.
     */
    public Double serviceTimeMin() {
        return this.serviceTimeMin;
    }

    /**
     * Set the serviceTimeMin property: Minimum time it took to process request on backend.
     * 
     * @param serviceTimeMin the serviceTimeMin value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withServiceTimeMin(Double serviceTimeMin) {
        this.serviceTimeMin = serviceTimeMin;
        return this;
    }

    /**
     * Get the serviceTimeMax property: Maximum time it took to process request on backend.
     * 
     * @return the serviceTimeMax value.
     */
    public Double serviceTimeMax() {
        return this.serviceTimeMax;
    }

    /**
     * Set the serviceTimeMax property: Maximum time it took to process request on backend.
     * 
     * @param serviceTimeMax the serviceTimeMax value to set.
     * @return the ReportRecordContractInner object itself.
     */
    public ReportRecordContractInner withServiceTimeMax(Double serviceTimeMax) {
        this.serviceTimeMax = serviceTimeMax;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("timestamp",
            this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("interval", this.interval);
        jsonWriter.writeStringField("country", this.country);
        jsonWriter.writeStringField("region", this.region);
        jsonWriter.writeStringField("zip", this.zip);
        jsonWriter.writeStringField("apiId", this.apiId);
        jsonWriter.writeStringField("operationId", this.operationId);
        jsonWriter.writeStringField("apiRegion", this.apiRegion);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeNumberField("callCountSuccess", this.callCountSuccess);
        jsonWriter.writeNumberField("callCountBlocked", this.callCountBlocked);
        jsonWriter.writeNumberField("callCountFailed", this.callCountFailed);
        jsonWriter.writeNumberField("callCountOther", this.callCountOther);
        jsonWriter.writeNumberField("callCountTotal", this.callCountTotal);
        jsonWriter.writeNumberField("bandwidth", this.bandwidth);
        jsonWriter.writeNumberField("cacheHitCount", this.cacheHitCount);
        jsonWriter.writeNumberField("cacheMissCount", this.cacheMissCount);
        jsonWriter.writeNumberField("apiTimeAvg", this.apiTimeAvg);
        jsonWriter.writeNumberField("apiTimeMin", this.apiTimeMin);
        jsonWriter.writeNumberField("apiTimeMax", this.apiTimeMax);
        jsonWriter.writeNumberField("serviceTimeAvg", this.serviceTimeAvg);
        jsonWriter.writeNumberField("serviceTimeMin", this.serviceTimeMin);
        jsonWriter.writeNumberField("serviceTimeMax", this.serviceTimeMax);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReportRecordContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReportRecordContractInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ReportRecordContractInner.
     */
    public static ReportRecordContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReportRecordContractInner deserializedReportRecordContractInner = new ReportRecordContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedReportRecordContractInner.name = reader.getString();
                } else if ("timestamp".equals(fieldName)) {
                    deserializedReportRecordContractInner.timestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("interval".equals(fieldName)) {
                    deserializedReportRecordContractInner.interval = reader.getString();
                } else if ("country".equals(fieldName)) {
                    deserializedReportRecordContractInner.country = reader.getString();
                } else if ("region".equals(fieldName)) {
                    deserializedReportRecordContractInner.region = reader.getString();
                } else if ("zip".equals(fieldName)) {
                    deserializedReportRecordContractInner.zip = reader.getString();
                } else if ("userId".equals(fieldName)) {
                    deserializedReportRecordContractInner.userId = reader.getString();
                } else if ("productId".equals(fieldName)) {
                    deserializedReportRecordContractInner.productId = reader.getString();
                } else if ("apiId".equals(fieldName)) {
                    deserializedReportRecordContractInner.apiId = reader.getString();
                } else if ("operationId".equals(fieldName)) {
                    deserializedReportRecordContractInner.operationId = reader.getString();
                } else if ("apiRegion".equals(fieldName)) {
                    deserializedReportRecordContractInner.apiRegion = reader.getString();
                } else if ("subscriptionId".equals(fieldName)) {
                    deserializedReportRecordContractInner.subscriptionId = reader.getString();
                } else if ("callCountSuccess".equals(fieldName)) {
                    deserializedReportRecordContractInner.callCountSuccess = reader.getNullable(JsonReader::getInt);
                } else if ("callCountBlocked".equals(fieldName)) {
                    deserializedReportRecordContractInner.callCountBlocked = reader.getNullable(JsonReader::getInt);
                } else if ("callCountFailed".equals(fieldName)) {
                    deserializedReportRecordContractInner.callCountFailed = reader.getNullable(JsonReader::getInt);
                } else if ("callCountOther".equals(fieldName)) {
                    deserializedReportRecordContractInner.callCountOther = reader.getNullable(JsonReader::getInt);
                } else if ("callCountTotal".equals(fieldName)) {
                    deserializedReportRecordContractInner.callCountTotal = reader.getNullable(JsonReader::getInt);
                } else if ("bandwidth".equals(fieldName)) {
                    deserializedReportRecordContractInner.bandwidth = reader.getNullable(JsonReader::getLong);
                } else if ("cacheHitCount".equals(fieldName)) {
                    deserializedReportRecordContractInner.cacheHitCount = reader.getNullable(JsonReader::getInt);
                } else if ("cacheMissCount".equals(fieldName)) {
                    deserializedReportRecordContractInner.cacheMissCount = reader.getNullable(JsonReader::getInt);
                } else if ("apiTimeAvg".equals(fieldName)) {
                    deserializedReportRecordContractInner.apiTimeAvg = reader.getNullable(JsonReader::getDouble);
                } else if ("apiTimeMin".equals(fieldName)) {
                    deserializedReportRecordContractInner.apiTimeMin = reader.getNullable(JsonReader::getDouble);
                } else if ("apiTimeMax".equals(fieldName)) {
                    deserializedReportRecordContractInner.apiTimeMax = reader.getNullable(JsonReader::getDouble);
                } else if ("serviceTimeAvg".equals(fieldName)) {
                    deserializedReportRecordContractInner.serviceTimeAvg = reader.getNullable(JsonReader::getDouble);
                } else if ("serviceTimeMin".equals(fieldName)) {
                    deserializedReportRecordContractInner.serviceTimeMin = reader.getNullable(JsonReader::getDouble);
                } else if ("serviceTimeMax".equals(fieldName)) {
                    deserializedReportRecordContractInner.serviceTimeMax = reader.getNullable(JsonReader::getDouble);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedReportRecordContractInner;
        });
    }
}
