// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Request Report data.
 */
@Fluent
public final class RequestReportRecordContractInner implements JsonSerializable<RequestReportRecordContractInner> {
    /*
     * API identifier path. /apis/{apiId}
     */
    private String apiId;

    /*
     * Operation identifier path. /apis/{apiId}/operations/{operationId}
     */
    private String operationId;

    /*
     * Product identifier path. /products/{productId}
     */
    private String productId;

    /*
     * User identifier path. /users/{userId}
     */
    private String userId;

    /*
     * The HTTP method associated with this request..
     */
    private String method;

    /*
     * The full URL associated with this request.
     */
    private String url;

    /*
     * The client IP address associated with this request.
     */
    private String ipAddress;

    /*
     * The HTTP status code received by the gateway as a result of forwarding this request to the backend.
     */
    private String backendResponseCode;

    /*
     * The HTTP status code returned by the gateway.
     */
    private Integer responseCode;

    /*
     * The size of the response returned by the gateway.
     */
    private Integer responseSize;

    /*
     * The date and time when this request was received by the gateway in ISO 8601 format.
     */
    private OffsetDateTime timestamp;

    /*
     * Specifies if response cache was involved in generating the response. If the value is none, the cache was not
     * used. If the value is hit, cached response was returned. If the value is miss, the cache was used but lookup
     * resulted in a miss and request was fulfilled by the backend.
     */
    private String cache;

    /*
     * The total time it took to process this request.
     */
    private Double apiTime;

    /*
     * he time it took to forward this request to the backend and get the response back.
     */
    private Double serviceTime;

    /*
     * Azure region where the gateway that processed this request is located.
     */
    private String apiRegion;

    /*
     * Subscription identifier path. /subscriptions/{subscriptionId}
     */
    private String subscriptionId;

    /*
     * Request Identifier.
     */
    private String requestId;

    /*
     * The size of this request..
     */
    private Integer requestSize;

    /**
     * Creates an instance of RequestReportRecordContractInner class.
     */
    public RequestReportRecordContractInner() {
    }

    /**
     * Get the apiId property: API identifier path. /apis/{apiId}.
     * 
     * @return the apiId value.
     */
    public String apiId() {
        return this.apiId;
    }

    /**
     * Set the apiId property: API identifier path. /apis/{apiId}.
     * 
     * @param apiId the apiId value to set.
     * @return the RequestReportRecordContractInner object itself.
     */
    public RequestReportRecordContractInner withApiId(String apiId) {
        this.apiId = apiId;
        return this;
    }

    /**
     * Get the operationId property: Operation identifier path. /apis/{apiId}/operations/{operationId}.
     * 
     * @return the operationId value.
     */
    public String operationId() {
        return this.operationId;
    }

    /**
     * Set the operationId property: Operation identifier path. /apis/{apiId}/operations/{operationId}.
     * 
     * @param operationId the operationId value to set.
     * @return the RequestReportRecordContractInner object itself.
     */
    public RequestReportRecordContractInner withOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    /**
     * Get the productId property: Product identifier path. /products/{productId}.
     * 
     * @return the productId value.
     */
    public String productId() {
        return this.productId;
    }

    /**
     * Get the userId property: User identifier path. /users/{userId}.
     * 
     * @return the userId value.
     */
    public String userId() {
        return this.userId;
    }

    /**
     * Get the method property: The HTTP method associated with this request..
     * 
     * @return the method value.
     */
    public String method() {
        return this.method;
    }

    /**
     * Set the method property: The HTTP method associated with this request..
     * 
     * @param method the method value to set.
     * @return the RequestReportRecordContractInner object itself.
     */
    public RequestReportRecordContractInner withMethod(String method) {
        this.method = method;
        return this;
    }

    /**
     * Get the url property: The full URL associated with this request.
     * 
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Set the url property: The full URL associated with this request.
     * 
     * @param url the url value to set.
     * @return the RequestReportRecordContractInner object itself.
     */
    public RequestReportRecordContractInner withUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Get the ipAddress property: The client IP address associated with this request.
     * 
     * @return the ipAddress value.
     */
    public String ipAddress() {
        return this.ipAddress;
    }

    /**
     * Set the ipAddress property: The client IP address associated with this request.
     * 
     * @param ipAddress the ipAddress value to set.
     * @return the RequestReportRecordContractInner object itself.
     */
    public RequestReportRecordContractInner withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    /**
     * Get the backendResponseCode property: The HTTP status code received by the gateway as a result of forwarding this
     * request to the backend.
     * 
     * @return the backendResponseCode value.
     */
    public String backendResponseCode() {
        return this.backendResponseCode;
    }

    /**
     * Set the backendResponseCode property: The HTTP status code received by the gateway as a result of forwarding this
     * request to the backend.
     * 
     * @param backendResponseCode the backendResponseCode value to set.
     * @return the RequestReportRecordContractInner object itself.
     */
    public RequestReportRecordContractInner withBackendResponseCode(String backendResponseCode) {
        this.backendResponseCode = backendResponseCode;
        return this;
    }

    /**
     * Get the responseCode property: The HTTP status code returned by the gateway.
     * 
     * @return the responseCode value.
     */
    public Integer responseCode() {
        return this.responseCode;
    }

    /**
     * Set the responseCode property: The HTTP status code returned by the gateway.
     * 
     * @param responseCode the responseCode value to set.
     * @return the RequestReportRecordContractInner object itself.
     */
    public RequestReportRecordContractInner withResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    /**
     * Get the responseSize property: The size of the response returned by the gateway.
     * 
     * @return the responseSize value.
     */
    public Integer responseSize() {
        return this.responseSize;
    }

    /**
     * Set the responseSize property: The size of the response returned by the gateway.
     * 
     * @param responseSize the responseSize value to set.
     * @return the RequestReportRecordContractInner object itself.
     */
    public RequestReportRecordContractInner withResponseSize(Integer responseSize) {
        this.responseSize = responseSize;
        return this;
    }

    /**
     * Get the timestamp property: The date and time when this request was received by the gateway in ISO 8601 format.
     * 
     * @return the timestamp value.
     */
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    /**
     * Set the timestamp property: The date and time when this request was received by the gateway in ISO 8601 format.
     * 
     * @param timestamp the timestamp value to set.
     * @return the RequestReportRecordContractInner object itself.
     */
    public RequestReportRecordContractInner withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    /**
     * Get the cache property: Specifies if response cache was involved in generating the response. If the value is
     * none, the cache was not used. If the value is hit, cached response was returned. If the value is miss, the cache
     * was used but lookup resulted in a miss and request was fulfilled by the backend.
     * 
     * @return the cache value.
     */
    public String cache() {
        return this.cache;
    }

    /**
     * Set the cache property: Specifies if response cache was involved in generating the response. If the value is
     * none, the cache was not used. If the value is hit, cached response was returned. If the value is miss, the cache
     * was used but lookup resulted in a miss and request was fulfilled by the backend.
     * 
     * @param cache the cache value to set.
     * @return the RequestReportRecordContractInner object itself.
     */
    public RequestReportRecordContractInner withCache(String cache) {
        this.cache = cache;
        return this;
    }

    /**
     * Get the apiTime property: The total time it took to process this request.
     * 
     * @return the apiTime value.
     */
    public Double apiTime() {
        return this.apiTime;
    }

    /**
     * Set the apiTime property: The total time it took to process this request.
     * 
     * @param apiTime the apiTime value to set.
     * @return the RequestReportRecordContractInner object itself.
     */
    public RequestReportRecordContractInner withApiTime(Double apiTime) {
        this.apiTime = apiTime;
        return this;
    }

    /**
     * Get the serviceTime property: he time it took to forward this request to the backend and get the response back.
     * 
     * @return the serviceTime value.
     */
    public Double serviceTime() {
        return this.serviceTime;
    }

    /**
     * Set the serviceTime property: he time it took to forward this request to the backend and get the response back.
     * 
     * @param serviceTime the serviceTime value to set.
     * @return the RequestReportRecordContractInner object itself.
     */
    public RequestReportRecordContractInner withServiceTime(Double serviceTime) {
        this.serviceTime = serviceTime;
        return this;
    }

    /**
     * Get the apiRegion property: Azure region where the gateway that processed this request is located.
     * 
     * @return the apiRegion value.
     */
    public String apiRegion() {
        return this.apiRegion;
    }

    /**
     * Set the apiRegion property: Azure region where the gateway that processed this request is located.
     * 
     * @param apiRegion the apiRegion value to set.
     * @return the RequestReportRecordContractInner object itself.
     */
    public RequestReportRecordContractInner withApiRegion(String apiRegion) {
        this.apiRegion = apiRegion;
        return this;
    }

    /**
     * Get the subscriptionId property: Subscription identifier path. /subscriptions/{subscriptionId}.
     * 
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Set the subscriptionId property: Subscription identifier path. /subscriptions/{subscriptionId}.
     * 
     * @param subscriptionId the subscriptionId value to set.
     * @return the RequestReportRecordContractInner object itself.
     */
    public RequestReportRecordContractInner withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    /**
     * Get the requestId property: Request Identifier.
     * 
     * @return the requestId value.
     */
    public String requestId() {
        return this.requestId;
    }

    /**
     * Set the requestId property: Request Identifier.
     * 
     * @param requestId the requestId value to set.
     * @return the RequestReportRecordContractInner object itself.
     */
    public RequestReportRecordContractInner withRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    /**
     * Get the requestSize property: The size of this request..
     * 
     * @return the requestSize value.
     */
    public Integer requestSize() {
        return this.requestSize;
    }

    /**
     * Set the requestSize property: The size of this request..
     * 
     * @param requestSize the requestSize value to set.
     * @return the RequestReportRecordContractInner object itself.
     */
    public RequestReportRecordContractInner withRequestSize(Integer requestSize) {
        this.requestSize = requestSize;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("apiId", this.apiId);
        jsonWriter.writeStringField("operationId", this.operationId);
        jsonWriter.writeStringField("method", this.method);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("ipAddress", this.ipAddress);
        jsonWriter.writeStringField("backendResponseCode", this.backendResponseCode);
        jsonWriter.writeNumberField("responseCode", this.responseCode);
        jsonWriter.writeNumberField("responseSize", this.responseSize);
        jsonWriter.writeStringField("timestamp",
            this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("cache", this.cache);
        jsonWriter.writeNumberField("apiTime", this.apiTime);
        jsonWriter.writeNumberField("serviceTime", this.serviceTime);
        jsonWriter.writeStringField("apiRegion", this.apiRegion);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("requestId", this.requestId);
        jsonWriter.writeNumberField("requestSize", this.requestSize);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RequestReportRecordContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RequestReportRecordContractInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RequestReportRecordContractInner.
     */
    public static RequestReportRecordContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RequestReportRecordContractInner deserializedRequestReportRecordContractInner
                = new RequestReportRecordContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("apiId".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.apiId = reader.getString();
                } else if ("operationId".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.operationId = reader.getString();
                } else if ("productId".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.productId = reader.getString();
                } else if ("userId".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.userId = reader.getString();
                } else if ("method".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.method = reader.getString();
                } else if ("url".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.url = reader.getString();
                } else if ("ipAddress".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.ipAddress = reader.getString();
                } else if ("backendResponseCode".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.backendResponseCode = reader.getString();
                } else if ("responseCode".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.responseCode = reader.getNullable(JsonReader::getInt);
                } else if ("responseSize".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.responseSize = reader.getNullable(JsonReader::getInt);
                } else if ("timestamp".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.timestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("cache".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.cache = reader.getString();
                } else if ("apiTime".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.apiTime = reader.getNullable(JsonReader::getDouble);
                } else if ("serviceTime".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.serviceTime
                        = reader.getNullable(JsonReader::getDouble);
                } else if ("apiRegion".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.apiRegion = reader.getString();
                } else if ("subscriptionId".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.subscriptionId = reader.getString();
                } else if ("requestId".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.requestId = reader.getString();
                } else if ("requestSize".equals(fieldName)) {
                    deserializedRequestReportRecordContractInner.requestSize = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRequestReportRecordContractInner;
        });
    }
}
