// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * GraphQL API Resolver details.
 */
@Fluent
public final class ResolverContractInner extends ProxyResource {
    /*
     * Properties of the Resolver Contract.
     */
    private ResolverEntityBaseContract innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ResolverContractInner class.
     */
    public ResolverContractInner() {
    }

    /**
     * Get the innerProperties property: Properties of the Resolver Contract.
     * 
     * @return the innerProperties value.
     */
    private ResolverEntityBaseContract innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the displayName property: Resolver Name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: Resolver Name.
     * 
     * @param displayName the displayName value to set.
     * @return the ResolverContractInner object itself.
     */
    public ResolverContractInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ResolverEntityBaseContract();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the path property: Path is type/field being resolved.
     * 
     * @return the path value.
     */
    public String path() {
        return this.innerProperties() == null ? null : this.innerProperties().path();
    }

    /**
     * Set the path property: Path is type/field being resolved.
     * 
     * @param path the path value to set.
     * @return the ResolverContractInner object itself.
     */
    public ResolverContractInner withPath(String path) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ResolverEntityBaseContract();
        }
        this.innerProperties().withPath(path);
        return this;
    }

    /**
     * Get the description property: Description of the resolver. May include HTML formatting tags.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Description of the resolver. May include HTML formatting tags.
     * 
     * @param description the description value to set.
     * @return the ResolverContractInner object itself.
     */
    public ResolverContractInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ResolverEntityBaseContract();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResolverContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResolverContractInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResolverContractInner.
     */
    public static ResolverContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResolverContractInner deserializedResolverContractInner = new ResolverContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedResolverContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedResolverContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedResolverContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedResolverContractInner.innerProperties = ResolverEntityBaseContract.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResolverContractInner;
        });
    }
}
