// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ResourceCollectionValueItem;
import java.io.IOException;
import java.util.List;

/**
 * A collection of resources.
 */
@Fluent
public final class ResourceCollectionInner implements JsonSerializable<ResourceCollectionInner> {
    /*
     * A collection of resources.
     */
    private List<ResourceCollectionValueItem> value;

    /*
     * Total record count number.
     */
    private Long count;

    /*
     * Next page link if any.
     */
    private String nextLink;

    /**
     * Creates an instance of ResourceCollectionInner class.
     */
    public ResourceCollectionInner() {
    }

    /**
     * Get the value property: A collection of resources.
     * 
     * @return the value value.
     */
    public List<ResourceCollectionValueItem> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of resources.
     * 
     * @param value the value value to set.
     * @return the ResourceCollectionInner object itself.
     */
    public ResourceCollectionInner withValue(List<ResourceCollectionValueItem> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the count property: Total record count number.
     * 
     * @return the count value.
     */
    public Long count() {
        return this.count;
    }

    /**
     * Set the count property: Total record count number.
     * 
     * @param count the count value to set.
     * @return the ResourceCollectionInner object itself.
     */
    public ResourceCollectionInner withCount(Long count) {
        this.count = count;
        return this;
    }

    /**
     * Get the nextLink property: Next page link if any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Next page link if any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ResourceCollectionInner object itself.
     */
    public ResourceCollectionInner withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("count", this.count);
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceCollectionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceCollectionInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceCollectionInner.
     */
    public static ResourceCollectionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceCollectionInner deserializedResourceCollectionInner = new ResourceCollectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ResourceCollectionValueItem> value
                        = reader.readArray(reader1 -> ResourceCollectionValueItem.fromJson(reader1));
                    deserializedResourceCollectionInner.value = value;
                } else if ("count".equals(fieldName)) {
                    deserializedResourceCollectionInner.count = reader.getNullable(JsonReader::getLong);
                } else if ("nextLink".equals(fieldName)) {
                    deserializedResourceCollectionInner.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceCollectionInner;
        });
    }
}
