// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ResourceSku;
import com.azure.resourcemanager.apimanagement.models.ResourceSkuCapacity;
import java.io.IOException;

/**
 * Describes an available API Management service SKU.
 */
@Immutable
public final class ResourceSkuResultInner implements JsonSerializable<ResourceSkuResultInner> {
    /*
     * The type of resource the SKU applies to.
     */
    private String resourceType;

    /*
     * Specifies API Management SKU.
     */
    private ResourceSku sku;

    /*
     * Specifies the number of API Management units.
     */
    private ResourceSkuCapacity capacity;

    /**
     * Creates an instance of ResourceSkuResultInner class.
     */
    public ResourceSkuResultInner() {
    }

    /**
     * Get the resourceType property: The type of resource the SKU applies to.
     * 
     * @return the resourceType value.
     */
    public String resourceType() {
        return this.resourceType;
    }

    /**
     * Get the sku property: Specifies API Management SKU.
     * 
     * @return the sku value.
     */
    public ResourceSku sku() {
        return this.sku;
    }

    /**
     * Get the capacity property: Specifies the number of API Management units.
     * 
     * @return the capacity value.
     */
    public ResourceSkuCapacity capacity() {
        return this.capacity;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() != null) {
            sku().validate();
        }
        if (capacity() != null) {
            capacity().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceSkuResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceSkuResultInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceSkuResultInner.
     */
    public static ResourceSkuResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceSkuResultInner deserializedResourceSkuResultInner = new ResourceSkuResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceType".equals(fieldName)) {
                    deserializedResourceSkuResultInner.resourceType = reader.getString();
                } else if ("sku".equals(fieldName)) {
                    deserializedResourceSkuResultInner.sku = ResourceSku.fromJson(reader);
                } else if ("capacity".equals(fieldName)) {
                    deserializedResourceSkuResultInner.capacity = ResourceSkuCapacity.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceSkuResultInner;
        });
    }
}
