// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * API Schema Contract details.
 */
@Fluent
public final class SchemaContractInner extends ProxyResource {
    /*
     * Properties of the API Schema.
     */
    private SchemaContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of SchemaContractInner class.
     */
    public SchemaContractInner() {
    }

    /**
     * Get the innerProperties property: Properties of the API Schema.
     * 
     * @return the innerProperties value.
     */
    private SchemaContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the contentType property: Must be a valid a media type used in a Content-Type header as defined in the RFC
     * 2616. Media type of the schema document (e.g. application/json, application/xml). &lt;/br&gt; - `Swagger` Schema
     * use `application/vnd.ms-azure-apim.swagger.definitions+json` &lt;/br&gt; - `WSDL` Schema use
     * `application/vnd.ms-azure-apim.xsd+xml` &lt;/br&gt; - `OpenApi` Schema use
     * `application/vnd.oai.openapi.components+json` &lt;/br&gt; - `WADL Schema` use
     * `application/vnd.ms-azure-apim.wadl.grammars+xml` &lt;/br&gt; - `OData Schema` use
     * `application/vnd.ms-azure-apim.odata.schema` &lt;/br&gt; - `gRPC Schema` use `text/protobuf`.
     * 
     * @return the contentType value.
     */
    public String contentType() {
        return this.innerProperties() == null ? null : this.innerProperties().contentType();
    }

    /**
     * Set the contentType property: Must be a valid a media type used in a Content-Type header as defined in the RFC
     * 2616. Media type of the schema document (e.g. application/json, application/xml). &lt;/br&gt; - `Swagger` Schema
     * use `application/vnd.ms-azure-apim.swagger.definitions+json` &lt;/br&gt; - `WSDL` Schema use
     * `application/vnd.ms-azure-apim.xsd+xml` &lt;/br&gt; - `OpenApi` Schema use
     * `application/vnd.oai.openapi.components+json` &lt;/br&gt; - `WADL Schema` use
     * `application/vnd.ms-azure-apim.wadl.grammars+xml` &lt;/br&gt; - `OData Schema` use
     * `application/vnd.ms-azure-apim.odata.schema` &lt;/br&gt; - `gRPC Schema` use `text/protobuf`.
     * 
     * @param contentType the contentType value to set.
     * @return the SchemaContractInner object itself.
     */
    public SchemaContractInner withContentType(String contentType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SchemaContractProperties();
        }
        this.innerProperties().withContentType(contentType);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the value property: Json escaped string defining the document representing the Schema. Used for schemas other
     * than Swagger/OpenAPI.
     * 
     * @return the value value.
     */
    public String value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    /**
     * Set the value property: Json escaped string defining the document representing the Schema. Used for schemas other
     * than Swagger/OpenAPI.
     * 
     * @param value the value value to set.
     * @return the SchemaContractInner object itself.
     */
    public SchemaContractInner withValue(String value) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SchemaContractProperties();
        }
        this.innerProperties().withValue(value);
        return this;
    }

    /**
     * Get the definitions property: Types definitions. Used for Swagger/OpenAPI v1 schemas only, null otherwise.
     * 
     * @return the definitions value.
     */
    public Object definitions() {
        return this.innerProperties() == null ? null : this.innerProperties().definitions();
    }

    /**
     * Set the definitions property: Types definitions. Used for Swagger/OpenAPI v1 schemas only, null otherwise.
     * 
     * @param definitions the definitions value to set.
     * @return the SchemaContractInner object itself.
     */
    public SchemaContractInner withDefinitions(Object definitions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SchemaContractProperties();
        }
        this.innerProperties().withDefinitions(definitions);
        return this;
    }

    /**
     * Get the components property: Types definitions. Used for Swagger/OpenAPI v2/v3 schemas only, null otherwise.
     * 
     * @return the components value.
     */
    public Object components() {
        return this.innerProperties() == null ? null : this.innerProperties().components();
    }

    /**
     * Set the components property: Types definitions. Used for Swagger/OpenAPI v2/v3 schemas only, null otherwise.
     * 
     * @param components the components value to set.
     * @return the SchemaContractInner object itself.
     */
    public SchemaContractInner withComponents(Object components) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SchemaContractProperties();
        }
        this.innerProperties().withComponents(components);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SchemaContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SchemaContractInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SchemaContractInner.
     */
    public static SchemaContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SchemaContractInner deserializedSchemaContractInner = new SchemaContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSchemaContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSchemaContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSchemaContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedSchemaContractInner.innerProperties = SchemaContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSchemaContractInner;
        });
    }
}
