// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * API Schema create or update contract Properties.
 */
@Fluent
public final class SchemaContractProperties implements JsonSerializable<SchemaContractProperties> {
    /*
     * Must be a valid a media type used in a Content-Type header as defined in the RFC 2616. Media type of the schema
     * document (e.g. application/json, application/xml). </br> - `Swagger` Schema use
     * `application/vnd.ms-azure-apim.swagger.definitions+json` </br> - `WSDL` Schema use
     * `application/vnd.ms-azure-apim.xsd+xml` </br> - `OpenApi` Schema use
     * `application/vnd.oai.openapi.components+json` </br> - `WADL Schema` use
     * `application/vnd.ms-azure-apim.wadl.grammars+xml` </br> - `OData Schema` use
     * `application/vnd.ms-azure-apim.odata.schema` </br> - `gRPC Schema` use `text/protobuf`.
     */
    private String contentType;

    /*
     * Create or update Properties of the API Schema Document.
     */
    private SchemaDocumentProperties innerDocument = new SchemaDocumentProperties();

    /*
     * The provisioning state
     */
    private String provisioningState;

    /**
     * Creates an instance of SchemaContractProperties class.
     */
    public SchemaContractProperties() {
    }

    /**
     * Get the contentType property: Must be a valid a media type used in a Content-Type header as defined in the RFC
     * 2616. Media type of the schema document (e.g. application/json, application/xml). &lt;/br&gt; - `Swagger` Schema
     * use `application/vnd.ms-azure-apim.swagger.definitions+json` &lt;/br&gt; - `WSDL` Schema use
     * `application/vnd.ms-azure-apim.xsd+xml` &lt;/br&gt; - `OpenApi` Schema use
     * `application/vnd.oai.openapi.components+json` &lt;/br&gt; - `WADL Schema` use
     * `application/vnd.ms-azure-apim.wadl.grammars+xml` &lt;/br&gt; - `OData Schema` use
     * `application/vnd.ms-azure-apim.odata.schema` &lt;/br&gt; - `gRPC Schema` use `text/protobuf`.
     * 
     * @return the contentType value.
     */
    public String contentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: Must be a valid a media type used in a Content-Type header as defined in the RFC
     * 2616. Media type of the schema document (e.g. application/json, application/xml). &lt;/br&gt; - `Swagger` Schema
     * use `application/vnd.ms-azure-apim.swagger.definitions+json` &lt;/br&gt; - `WSDL` Schema use
     * `application/vnd.ms-azure-apim.xsd+xml` &lt;/br&gt; - `OpenApi` Schema use
     * `application/vnd.oai.openapi.components+json` &lt;/br&gt; - `WADL Schema` use
     * `application/vnd.ms-azure-apim.wadl.grammars+xml` &lt;/br&gt; - `OData Schema` use
     * `application/vnd.ms-azure-apim.odata.schema` &lt;/br&gt; - `gRPC Schema` use `text/protobuf`.
     * 
     * @param contentType the contentType value to set.
     * @return the SchemaContractProperties object itself.
     */
    public SchemaContractProperties withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the innerDocument property: Create or update Properties of the API Schema Document.
     * 
     * @return the innerDocument value.
     */
    private SchemaDocumentProperties innerDocument() {
        return this.innerDocument;
    }

    /**
     * Get the provisioningState property: The provisioning state.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the value property: Json escaped string defining the document representing the Schema. Used for schemas other
     * than Swagger/OpenAPI.
     * 
     * @return the value value.
     */
    public String value() {
        return this.innerDocument() == null ? null : this.innerDocument().value();
    }

    /**
     * Set the value property: Json escaped string defining the document representing the Schema. Used for schemas other
     * than Swagger/OpenAPI.
     * 
     * @param value the value value to set.
     * @return the SchemaContractProperties object itself.
     */
    public SchemaContractProperties withValue(String value) {
        if (this.innerDocument() == null) {
            this.innerDocument = new SchemaDocumentProperties();
        }
        this.innerDocument().withValue(value);
        return this;
    }

    /**
     * Get the definitions property: Types definitions. Used for Swagger/OpenAPI v1 schemas only, null otherwise.
     * 
     * @return the definitions value.
     */
    public Object definitions() {
        return this.innerDocument() == null ? null : this.innerDocument().definitions();
    }

    /**
     * Set the definitions property: Types definitions. Used for Swagger/OpenAPI v1 schemas only, null otherwise.
     * 
     * @param definitions the definitions value to set.
     * @return the SchemaContractProperties object itself.
     */
    public SchemaContractProperties withDefinitions(Object definitions) {
        if (this.innerDocument() == null) {
            this.innerDocument = new SchemaDocumentProperties();
        }
        this.innerDocument().withDefinitions(definitions);
        return this;
    }

    /**
     * Get the components property: Types definitions. Used for Swagger/OpenAPI v2/v3 schemas only, null otherwise.
     * 
     * @return the components value.
     */
    public Object components() {
        return this.innerDocument() == null ? null : this.innerDocument().components();
    }

    /**
     * Set the components property: Types definitions. Used for Swagger/OpenAPI v2/v3 schemas only, null otherwise.
     * 
     * @param components the components value to set.
     * @return the SchemaContractProperties object itself.
     */
    public SchemaContractProperties withComponents(Object components) {
        if (this.innerDocument() == null) {
            this.innerDocument = new SchemaDocumentProperties();
        }
        this.innerDocument().withComponents(components);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (contentType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property contentType in model SchemaContractProperties"));
        }
        if (innerDocument() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerDocument in model SchemaContractProperties"));
        } else {
            innerDocument().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SchemaContractProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeJsonField("document", this.innerDocument);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SchemaContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SchemaContractProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SchemaContractProperties.
     */
    public static SchemaContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SchemaContractProperties deserializedSchemaContractProperties = new SchemaContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("contentType".equals(fieldName)) {
                    deserializedSchemaContractProperties.contentType = reader.getString();
                } else if ("document".equals(fieldName)) {
                    deserializedSchemaContractProperties.innerDocument = SchemaDocumentProperties.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedSchemaContractProperties.provisioningState = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSchemaContractProperties;
        });
    }
}
