// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Api Schema Document Properties.
 */
@Fluent
public final class SchemaDocumentProperties implements JsonSerializable<SchemaDocumentProperties> {
    /*
     * Json escaped string defining the document representing the Schema. Used for schemas other than Swagger/OpenAPI.
     */
    private String value;

    /*
     * Types definitions. Used for Swagger/OpenAPI v1 schemas only, null otherwise.
     */
    private Object definitions;

    /*
     * Types definitions. Used for Swagger/OpenAPI v2/v3 schemas only, null otherwise.
     */
    private Object components;

    /**
     * Creates an instance of SchemaDocumentProperties class.
     */
    public SchemaDocumentProperties() {
    }

    /**
     * Get the value property: Json escaped string defining the document representing the Schema. Used for schemas other
     * than Swagger/OpenAPI.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Json escaped string defining the document representing the Schema. Used for schemas other
     * than Swagger/OpenAPI.
     * 
     * @param value the value value to set.
     * @return the SchemaDocumentProperties object itself.
     */
    public SchemaDocumentProperties withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the definitions property: Types definitions. Used for Swagger/OpenAPI v1 schemas only, null otherwise.
     * 
     * @return the definitions value.
     */
    public Object definitions() {
        return this.definitions;
    }

    /**
     * Set the definitions property: Types definitions. Used for Swagger/OpenAPI v1 schemas only, null otherwise.
     * 
     * @param definitions the definitions value to set.
     * @return the SchemaDocumentProperties object itself.
     */
    public SchemaDocumentProperties withDefinitions(Object definitions) {
        this.definitions = definitions;
        return this;
    }

    /**
     * Get the components property: Types definitions. Used for Swagger/OpenAPI v2/v3 schemas only, null otherwise.
     * 
     * @return the components value.
     */
    public Object components() {
        return this.components;
    }

    /**
     * Set the components property: Types definitions. Used for Swagger/OpenAPI v2/v3 schemas only, null otherwise.
     * 
     * @param components the components value to set.
     * @return the SchemaDocumentProperties object itself.
     */
    public SchemaDocumentProperties withComponents(Object components) {
        this.components = components;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeUntypedField("definitions", this.definitions);
        jsonWriter.writeUntypedField("components", this.components);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SchemaDocumentProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SchemaDocumentProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SchemaDocumentProperties.
     */
    public static SchemaDocumentProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SchemaDocumentProperties deserializedSchemaDocumentProperties = new SchemaDocumentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedSchemaDocumentProperties.value = reader.getString();
                } else if ("definitions".equals(fieldName)) {
                    deserializedSchemaDocumentProperties.definitions = reader.readUntyped();
                } else if ("components".equals(fieldName)) {
                    deserializedSchemaDocumentProperties.components = reader.readUntyped();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSchemaDocumentProperties;
        });
    }
}
