// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.SubscriptionState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Subscription details.
 */
@Fluent
public final class SubscriptionContractProperties implements JsonSerializable<SubscriptionContractProperties> {
    /*
     * The user resource identifier of the subscription owner. The value is a valid relative URL in the format of
     * /users/{userId} where {userId} is a user identifier.
     */
    private String ownerId;

    /*
     * Scope like /products/{productId} or /apis or /apis/{apiId}.
     */
    private String scope;

    /*
     * The name of the subscription, or null if the subscription has no name.
     */
    private String displayName;

    /*
     * Subscription state. Possible states are * active – the subscription is active, * suspended – the subscription is
     * blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been
     * made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been
     * denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator,
     * * expired – the subscription reached its expiration date and was deactivated.
     */
    private SubscriptionState state;

    /*
     * Subscription creation date. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the
     * ISO 8601 standard.
     */
    private OffsetDateTime createdDate;

    /*
     * Subscription activation date. The setting is for audit purposes only and the subscription is not automatically
     * activated. The subscription lifecycle can be managed by using the `state` property. The date conforms to the
     * following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     */
    private OffsetDateTime startDate;

    /*
     * Subscription expiration date. The setting is for audit purposes only and the subscription is not automatically
     * expired. The subscription lifecycle can be managed by using the `state` property. The date conforms to the
     * following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     */
    private OffsetDateTime expirationDate;

    /*
     * Date when subscription was cancelled or expired. The setting is for audit purposes only and the subscription is
     * not automatically cancelled. The subscription lifecycle can be managed by using the `state` property. The date
     * conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     */
    private OffsetDateTime endDate;

    /*
     * Upcoming subscription expiration notification date. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     */
    private OffsetDateTime notificationDate;

    /*
     * Subscription primary key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request
     * to get the value.
     */
    private String primaryKey;

    /*
     * Subscription secondary key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request
     * to get the value.
     */
    private String secondaryKey;

    /*
     * Optional subscription comment added by an administrator when the state is changed to the 'rejected'.
     */
    private String stateComment;

    /*
     * Determines whether tracing is enabled
     */
    private Boolean allowTracing;

    /**
     * Creates an instance of SubscriptionContractProperties class.
     */
    public SubscriptionContractProperties() {
    }

    /**
     * Get the ownerId property: The user resource identifier of the subscription owner. The value is a valid relative
     * URL in the format of /users/{userId} where {userId} is a user identifier.
     * 
     * @return the ownerId value.
     */
    public String ownerId() {
        return this.ownerId;
    }

    /**
     * Set the ownerId property: The user resource identifier of the subscription owner. The value is a valid relative
     * URL in the format of /users/{userId} where {userId} is a user identifier.
     * 
     * @param ownerId the ownerId value to set.
     * @return the SubscriptionContractProperties object itself.
     */
    public SubscriptionContractProperties withOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    /**
     * Get the scope property: Scope like /products/{productId} or /apis or /apis/{apiId}.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.scope;
    }

    /**
     * Set the scope property: Scope like /products/{productId} or /apis or /apis/{apiId}.
     * 
     * @param scope the scope value to set.
     * @return the SubscriptionContractProperties object itself.
     */
    public SubscriptionContractProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the displayName property: The name of the subscription, or null if the subscription has no name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The name of the subscription, or null if the subscription has no name.
     * 
     * @param displayName the displayName value to set.
     * @return the SubscriptionContractProperties object itself.
     */
    public SubscriptionContractProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the state property: Subscription state. Possible states are * active – the subscription is active, *
     * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted –
     * the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected –
     * the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled
     * by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated.
     * 
     * @return the state value.
     */
    public SubscriptionState state() {
        return this.state;
    }

    /**
     * Set the state property: Subscription state. Possible states are * active – the subscription is active, *
     * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted –
     * the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected –
     * the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled
     * by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated.
     * 
     * @param state the state value to set.
     * @return the SubscriptionContractProperties object itself.
     */
    public SubscriptionContractProperties withState(SubscriptionState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the createdDate property: Subscription creation date. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the createdDate value.
     */
    public OffsetDateTime createdDate() {
        return this.createdDate;
    }

    /**
     * Get the startDate property: Subscription activation date. The setting is for audit purposes only and the
     * subscription is not automatically activated. The subscription lifecycle can be managed by using the `state`
     * property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601
     * standard.
     * 
     * @return the startDate value.
     */
    public OffsetDateTime startDate() {
        return this.startDate;
    }

    /**
     * Set the startDate property: Subscription activation date. The setting is for audit purposes only and the
     * subscription is not automatically activated. The subscription lifecycle can be managed by using the `state`
     * property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601
     * standard.
     * 
     * @param startDate the startDate value to set.
     * @return the SubscriptionContractProperties object itself.
     */
    public SubscriptionContractProperties withStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    /**
     * Get the expirationDate property: Subscription expiration date. The setting is for audit purposes only and the
     * subscription is not automatically expired. The subscription lifecycle can be managed by using the `state`
     * property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601
     * standard.
     * 
     * @return the expirationDate value.
     */
    public OffsetDateTime expirationDate() {
        return this.expirationDate;
    }

    /**
     * Set the expirationDate property: Subscription expiration date. The setting is for audit purposes only and the
     * subscription is not automatically expired. The subscription lifecycle can be managed by using the `state`
     * property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601
     * standard.
     * 
     * @param expirationDate the expirationDate value to set.
     * @return the SubscriptionContractProperties object itself.
     */
    public SubscriptionContractProperties withExpirationDate(OffsetDateTime expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    /**
     * Get the endDate property: Date when subscription was cancelled or expired. The setting is for audit purposes only
     * and the subscription is not automatically cancelled. The subscription lifecycle can be managed by using the
     * `state` property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601
     * standard.
     * 
     * @return the endDate value.
     */
    public OffsetDateTime endDate() {
        return this.endDate;
    }

    /**
     * Set the endDate property: Date when subscription was cancelled or expired. The setting is for audit purposes only
     * and the subscription is not automatically cancelled. The subscription lifecycle can be managed by using the
     * `state` property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601
     * standard.
     * 
     * @param endDate the endDate value to set.
     * @return the SubscriptionContractProperties object itself.
     */
    public SubscriptionContractProperties withEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    /**
     * Get the notificationDate property: Upcoming subscription expiration notification date. The date conforms to the
     * following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the notificationDate value.
     */
    public OffsetDateTime notificationDate() {
        return this.notificationDate;
    }

    /**
     * Set the notificationDate property: Upcoming subscription expiration notification date. The date conforms to the
     * following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @param notificationDate the notificationDate value to set.
     * @return the SubscriptionContractProperties object itself.
     */
    public SubscriptionContractProperties withNotificationDate(OffsetDateTime notificationDate) {
        this.notificationDate = notificationDate;
        return this;
    }

    /**
     * Get the primaryKey property: Subscription primary key. This property will not be filled on 'GET' operations! Use
     * '/listSecrets' POST request to get the value.
     * 
     * @return the primaryKey value.
     */
    public String primaryKey() {
        return this.primaryKey;
    }

    /**
     * Set the primaryKey property: Subscription primary key. This property will not be filled on 'GET' operations! Use
     * '/listSecrets' POST request to get the value.
     * 
     * @param primaryKey the primaryKey value to set.
     * @return the SubscriptionContractProperties object itself.
     */
    public SubscriptionContractProperties withPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    /**
     * Get the secondaryKey property: Subscription secondary key. This property will not be filled on 'GET' operations!
     * Use '/listSecrets' POST request to get the value.
     * 
     * @return the secondaryKey value.
     */
    public String secondaryKey() {
        return this.secondaryKey;
    }

    /**
     * Set the secondaryKey property: Subscription secondary key. This property will not be filled on 'GET' operations!
     * Use '/listSecrets' POST request to get the value.
     * 
     * @param secondaryKey the secondaryKey value to set.
     * @return the SubscriptionContractProperties object itself.
     */
    public SubscriptionContractProperties withSecondaryKey(String secondaryKey) {
        this.secondaryKey = secondaryKey;
        return this;
    }

    /**
     * Get the stateComment property: Optional subscription comment added by an administrator when the state is changed
     * to the 'rejected'.
     * 
     * @return the stateComment value.
     */
    public String stateComment() {
        return this.stateComment;
    }

    /**
     * Set the stateComment property: Optional subscription comment added by an administrator when the state is changed
     * to the 'rejected'.
     * 
     * @param stateComment the stateComment value to set.
     * @return the SubscriptionContractProperties object itself.
     */
    public SubscriptionContractProperties withStateComment(String stateComment) {
        this.stateComment = stateComment;
        return this;
    }

    /**
     * Get the allowTracing property: Determines whether tracing is enabled.
     * 
     * @return the allowTracing value.
     */
    public Boolean allowTracing() {
        return this.allowTracing;
    }

    /**
     * Set the allowTracing property: Determines whether tracing is enabled.
     * 
     * @param allowTracing the allowTracing value to set.
     * @return the SubscriptionContractProperties object itself.
     */
    public SubscriptionContractProperties withAllowTracing(Boolean allowTracing) {
        this.allowTracing = allowTracing;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (scope() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property scope in model SubscriptionContractProperties"));
        }
        if (state() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property state in model SubscriptionContractProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SubscriptionContractProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("ownerId", this.ownerId);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("startDate",
            this.startDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDate));
        jsonWriter.writeStringField("expirationDate",
            this.expirationDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDate));
        jsonWriter.writeStringField("endDate",
            this.endDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDate));
        jsonWriter.writeStringField("notificationDate",
            this.notificationDate == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.notificationDate));
        jsonWriter.writeStringField("primaryKey", this.primaryKey);
        jsonWriter.writeStringField("secondaryKey", this.secondaryKey);
        jsonWriter.writeStringField("stateComment", this.stateComment);
        jsonWriter.writeBooleanField("allowTracing", this.allowTracing);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SubscriptionContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SubscriptionContractProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SubscriptionContractProperties.
     */
    public static SubscriptionContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SubscriptionContractProperties deserializedSubscriptionContractProperties
                = new SubscriptionContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scope".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.scope = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.state = SubscriptionState.fromString(reader.getString());
                } else if ("ownerId".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.ownerId = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.displayName = reader.getString();
                } else if ("createdDate".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.createdDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("startDate".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.startDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("expirationDate".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.expirationDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endDate".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.endDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("notificationDate".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.notificationDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("primaryKey".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.primaryKey = reader.getString();
                } else if ("secondaryKey".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.secondaryKey = reader.getString();
                } else if ("stateComment".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.stateComment = reader.getString();
                } else if ("allowTracing".equals(fieldName)) {
                    deserializedSubscriptionContractProperties.allowTracing
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSubscriptionContractProperties;
        });
    }
}
