// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.SubscriptionState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Parameters supplied to the Update subscription operation.
 */
@Fluent
public final class SubscriptionUpdateParameterProperties
    implements JsonSerializable<SubscriptionUpdateParameterProperties> {
    /*
     * User identifier path: /users/{userId}
     */
    private String ownerId;

    /*
     * Scope like /products/{productId} or /apis or /apis/{apiId}
     */
    private String scope;

    /*
     * Subscription expiration date. The setting is for audit purposes only and the subscription is not automatically
     * expired. The subscription lifecycle can be managed by using the `state` property. The date conforms to the
     * following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     */
    private OffsetDateTime expirationDate;

    /*
     * Subscription name.
     */
    private String displayName;

    /*
     * Primary subscription key.
     */
    private String primaryKey;

    /*
     * Secondary subscription key.
     */
    private String secondaryKey;

    /*
     * Subscription state. Possible states are * active – the subscription is active, * suspended – the subscription is
     * blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been
     * made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been
     * denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator,
     * * expired – the subscription reached its expiration date and was deactivated.
     */
    private SubscriptionState state;

    /*
     * Comments describing subscription state change by the administrator when the state is changed to the 'rejected'.
     */
    private String stateComment;

    /*
     * Determines whether tracing can be enabled
     */
    private Boolean allowTracing;

    /**
     * Creates an instance of SubscriptionUpdateParameterProperties class.
     */
    public SubscriptionUpdateParameterProperties() {
    }

    /**
     * Get the ownerId property: User identifier path: /users/{userId}.
     * 
     * @return the ownerId value.
     */
    public String ownerId() {
        return this.ownerId;
    }

    /**
     * Set the ownerId property: User identifier path: /users/{userId}.
     * 
     * @param ownerId the ownerId value to set.
     * @return the SubscriptionUpdateParameterProperties object itself.
     */
    public SubscriptionUpdateParameterProperties withOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    /**
     * Get the scope property: Scope like /products/{productId} or /apis or /apis/{apiId}.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.scope;
    }

    /**
     * Set the scope property: Scope like /products/{productId} or /apis or /apis/{apiId}.
     * 
     * @param scope the scope value to set.
     * @return the SubscriptionUpdateParameterProperties object itself.
     */
    public SubscriptionUpdateParameterProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the expirationDate property: Subscription expiration date. The setting is for audit purposes only and the
     * subscription is not automatically expired. The subscription lifecycle can be managed by using the `state`
     * property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601
     * standard.
     * 
     * @return the expirationDate value.
     */
    public OffsetDateTime expirationDate() {
        return this.expirationDate;
    }

    /**
     * Set the expirationDate property: Subscription expiration date. The setting is for audit purposes only and the
     * subscription is not automatically expired. The subscription lifecycle can be managed by using the `state`
     * property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601
     * standard.
     * 
     * @param expirationDate the expirationDate value to set.
     * @return the SubscriptionUpdateParameterProperties object itself.
     */
    public SubscriptionUpdateParameterProperties withExpirationDate(OffsetDateTime expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    /**
     * Get the displayName property: Subscription name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Subscription name.
     * 
     * @param displayName the displayName value to set.
     * @return the SubscriptionUpdateParameterProperties object itself.
     */
    public SubscriptionUpdateParameterProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the primaryKey property: Primary subscription key.
     * 
     * @return the primaryKey value.
     */
    public String primaryKey() {
        return this.primaryKey;
    }

    /**
     * Set the primaryKey property: Primary subscription key.
     * 
     * @param primaryKey the primaryKey value to set.
     * @return the SubscriptionUpdateParameterProperties object itself.
     */
    public SubscriptionUpdateParameterProperties withPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    /**
     * Get the secondaryKey property: Secondary subscription key.
     * 
     * @return the secondaryKey value.
     */
    public String secondaryKey() {
        return this.secondaryKey;
    }

    /**
     * Set the secondaryKey property: Secondary subscription key.
     * 
     * @param secondaryKey the secondaryKey value to set.
     * @return the SubscriptionUpdateParameterProperties object itself.
     */
    public SubscriptionUpdateParameterProperties withSecondaryKey(String secondaryKey) {
        this.secondaryKey = secondaryKey;
        return this;
    }

    /**
     * Get the state property: Subscription state. Possible states are * active – the subscription is active, *
     * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted –
     * the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected –
     * the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled
     * by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated.
     * 
     * @return the state value.
     */
    public SubscriptionState state() {
        return this.state;
    }

    /**
     * Set the state property: Subscription state. Possible states are * active – the subscription is active, *
     * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted –
     * the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected –
     * the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled
     * by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated.
     * 
     * @param state the state value to set.
     * @return the SubscriptionUpdateParameterProperties object itself.
     */
    public SubscriptionUpdateParameterProperties withState(SubscriptionState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the stateComment property: Comments describing subscription state change by the administrator when the state
     * is changed to the 'rejected'.
     * 
     * @return the stateComment value.
     */
    public String stateComment() {
        return this.stateComment;
    }

    /**
     * Set the stateComment property: Comments describing subscription state change by the administrator when the state
     * is changed to the 'rejected'.
     * 
     * @param stateComment the stateComment value to set.
     * @return the SubscriptionUpdateParameterProperties object itself.
     */
    public SubscriptionUpdateParameterProperties withStateComment(String stateComment) {
        this.stateComment = stateComment;
        return this;
    }

    /**
     * Get the allowTracing property: Determines whether tracing can be enabled.
     * 
     * @return the allowTracing value.
     */
    public Boolean allowTracing() {
        return this.allowTracing;
    }

    /**
     * Set the allowTracing property: Determines whether tracing can be enabled.
     * 
     * @param allowTracing the allowTracing value to set.
     * @return the SubscriptionUpdateParameterProperties object itself.
     */
    public SubscriptionUpdateParameterProperties withAllowTracing(Boolean allowTracing) {
        this.allowTracing = allowTracing;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ownerId", this.ownerId);
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeStringField("expirationDate",
            this.expirationDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDate));
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("primaryKey", this.primaryKey);
        jsonWriter.writeStringField("secondaryKey", this.secondaryKey);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("stateComment", this.stateComment);
        jsonWriter.writeBooleanField("allowTracing", this.allowTracing);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SubscriptionUpdateParameterProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SubscriptionUpdateParameterProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SubscriptionUpdateParameterProperties.
     */
    public static SubscriptionUpdateParameterProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SubscriptionUpdateParameterProperties deserializedSubscriptionUpdateParameterProperties
                = new SubscriptionUpdateParameterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ownerId".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameterProperties.ownerId = reader.getString();
                } else if ("scope".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameterProperties.scope = reader.getString();
                } else if ("expirationDate".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameterProperties.expirationDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("displayName".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameterProperties.displayName = reader.getString();
                } else if ("primaryKey".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameterProperties.primaryKey = reader.getString();
                } else if ("secondaryKey".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameterProperties.secondaryKey = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameterProperties.state
                        = SubscriptionState.fromString(reader.getString());
                } else if ("stateComment".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameterProperties.stateComment = reader.getString();
                } else if ("allowTracing".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameterProperties.allowTracing
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSubscriptionUpdateParameterProperties;
        });
    }
}
