// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Tag-API link details.
 */
@Fluent
public final class TagApiLinkContractInner extends ProxyResource {
    /*
     * Tag-API link entity contract properties.
     */
    private TagApiLinkContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of TagApiLinkContractInner class.
     */
    public TagApiLinkContractInner() {
    }

    /**
     * Get the innerProperties property: Tag-API link entity contract properties.
     * 
     * @return the innerProperties value.
     */
    private TagApiLinkContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the apiId property: Full resource Id of an API.
     * 
     * @return the apiId value.
     */
    public String apiId() {
        return this.innerProperties() == null ? null : this.innerProperties().apiId();
    }

    /**
     * Set the apiId property: Full resource Id of an API.
     * 
     * @param apiId the apiId value to set.
     * @return the TagApiLinkContractInner object itself.
     */
    public TagApiLinkContractInner withApiId(String apiId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TagApiLinkContractProperties();
        }
        this.innerProperties().withApiId(apiId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TagApiLinkContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TagApiLinkContractInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TagApiLinkContractInner.
     */
    public static TagApiLinkContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TagApiLinkContractInner deserializedTagApiLinkContractInner = new TagApiLinkContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedTagApiLinkContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedTagApiLinkContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedTagApiLinkContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedTagApiLinkContractInner.innerProperties = TagApiLinkContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTagApiLinkContractInner;
        });
    }
}
