// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Tag-API link entity properties.
 */
@Fluent
public final class TagApiLinkContractProperties implements JsonSerializable<TagApiLinkContractProperties> {
    /*
     * Full resource Id of an API.
     */
    private String apiId;

    /**
     * Creates an instance of TagApiLinkContractProperties class.
     */
    public TagApiLinkContractProperties() {
    }

    /**
     * Get the apiId property: Full resource Id of an API.
     * 
     * @return the apiId value.
     */
    public String apiId() {
        return this.apiId;
    }

    /**
     * Set the apiId property: Full resource Id of an API.
     * 
     * @param apiId the apiId value to set.
     * @return the TagApiLinkContractProperties object itself.
     */
    public TagApiLinkContractProperties withApiId(String apiId) {
        this.apiId = apiId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (apiId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property apiId in model TagApiLinkContractProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TagApiLinkContractProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("apiId", this.apiId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TagApiLinkContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TagApiLinkContractProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TagApiLinkContractProperties.
     */
    public static TagApiLinkContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TagApiLinkContractProperties deserializedTagApiLinkContractProperties = new TagApiLinkContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("apiId".equals(fieldName)) {
                    deserializedTagApiLinkContractProperties.apiId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTagApiLinkContractProperties;
        });
    }
}
