// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters supplied to the Create TagDescription operation.
 */
@Fluent
public class TagDescriptionBaseProperties implements JsonSerializable<TagDescriptionBaseProperties> {
    /*
     * Description of the Tag.
     */
    private String description;

    /*
     * Absolute URL of external resources describing the tag.
     */
    private String externalDocsUrl;

    /*
     * Description of the external resources describing the tag.
     */
    private String externalDocsDescription;

    /**
     * Creates an instance of TagDescriptionBaseProperties class.
     */
    public TagDescriptionBaseProperties() {
    }

    /**
     * Get the description property: Description of the Tag.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the Tag.
     * 
     * @param description the description value to set.
     * @return the TagDescriptionBaseProperties object itself.
     */
    public TagDescriptionBaseProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the externalDocsUrl property: Absolute URL of external resources describing the tag.
     * 
     * @return the externalDocsUrl value.
     */
    public String externalDocsUrl() {
        return this.externalDocsUrl;
    }

    /**
     * Set the externalDocsUrl property: Absolute URL of external resources describing the tag.
     * 
     * @param externalDocsUrl the externalDocsUrl value to set.
     * @return the TagDescriptionBaseProperties object itself.
     */
    public TagDescriptionBaseProperties withExternalDocsUrl(String externalDocsUrl) {
        this.externalDocsUrl = externalDocsUrl;
        return this;
    }

    /**
     * Get the externalDocsDescription property: Description of the external resources describing the tag.
     * 
     * @return the externalDocsDescription value.
     */
    public String externalDocsDescription() {
        return this.externalDocsDescription;
    }

    /**
     * Set the externalDocsDescription property: Description of the external resources describing the tag.
     * 
     * @param externalDocsDescription the externalDocsDescription value to set.
     * @return the TagDescriptionBaseProperties object itself.
     */
    public TagDescriptionBaseProperties withExternalDocsDescription(String externalDocsDescription) {
        this.externalDocsDescription = externalDocsDescription;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("externalDocsUrl", this.externalDocsUrl);
        jsonWriter.writeStringField("externalDocsDescription", this.externalDocsDescription);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TagDescriptionBaseProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TagDescriptionBaseProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TagDescriptionBaseProperties.
     */
    public static TagDescriptionBaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TagDescriptionBaseProperties deserializedTagDescriptionBaseProperties = new TagDescriptionBaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedTagDescriptionBaseProperties.description = reader.getString();
                } else if ("externalDocsUrl".equals(fieldName)) {
                    deserializedTagDescriptionBaseProperties.externalDocsUrl = reader.getString();
                } else if ("externalDocsDescription".equals(fieldName)) {
                    deserializedTagDescriptionBaseProperties.externalDocsDescription = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTagDescriptionBaseProperties;
        });
    }
}
