// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contract details.
 */
@Fluent
public final class TagDescriptionContractInner extends ProxyResource {
    /*
     * TagDescription entity contract properties.
     */
    private TagDescriptionContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of TagDescriptionContractInner class.
     */
    public TagDescriptionContractInner() {
    }

    /**
     * Get the innerProperties property: TagDescription entity contract properties.
     * 
     * @return the innerProperties value.
     */
    private TagDescriptionContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the tagId property: Identifier of the tag in the form of /tags/{tagId}.
     * 
     * @return the tagId value.
     */
    public String tagId() {
        return this.innerProperties() == null ? null : this.innerProperties().tagId();
    }

    /**
     * Set the tagId property: Identifier of the tag in the form of /tags/{tagId}.
     * 
     * @param tagId the tagId value to set.
     * @return the TagDescriptionContractInner object itself.
     */
    public TagDescriptionContractInner withTagId(String tagId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TagDescriptionContractProperties();
        }
        this.innerProperties().withTagId(tagId);
        return this;
    }

    /**
     * Get the displayName property: Tag name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: Tag name.
     * 
     * @param displayName the displayName value to set.
     * @return the TagDescriptionContractInner object itself.
     */
    public TagDescriptionContractInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TagDescriptionContractProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the description property: Description of the Tag.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Description of the Tag.
     * 
     * @param description the description value to set.
     * @return the TagDescriptionContractInner object itself.
     */
    public TagDescriptionContractInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TagDescriptionContractProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the externalDocsUrl property: Absolute URL of external resources describing the tag.
     * 
     * @return the externalDocsUrl value.
     */
    public String externalDocsUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().externalDocsUrl();
    }

    /**
     * Set the externalDocsUrl property: Absolute URL of external resources describing the tag.
     * 
     * @param externalDocsUrl the externalDocsUrl value to set.
     * @return the TagDescriptionContractInner object itself.
     */
    public TagDescriptionContractInner withExternalDocsUrl(String externalDocsUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TagDescriptionContractProperties();
        }
        this.innerProperties().withExternalDocsUrl(externalDocsUrl);
        return this;
    }

    /**
     * Get the externalDocsDescription property: Description of the external resources describing the tag.
     * 
     * @return the externalDocsDescription value.
     */
    public String externalDocsDescription() {
        return this.innerProperties() == null ? null : this.innerProperties().externalDocsDescription();
    }

    /**
     * Set the externalDocsDescription property: Description of the external resources describing the tag.
     * 
     * @param externalDocsDescription the externalDocsDescription value to set.
     * @return the TagDescriptionContractInner object itself.
     */
    public TagDescriptionContractInner withExternalDocsDescription(String externalDocsDescription) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TagDescriptionContractProperties();
        }
        this.innerProperties().withExternalDocsDescription(externalDocsDescription);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TagDescriptionContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TagDescriptionContractInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TagDescriptionContractInner.
     */
    public static TagDescriptionContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TagDescriptionContractInner deserializedTagDescriptionContractInner = new TagDescriptionContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedTagDescriptionContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedTagDescriptionContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedTagDescriptionContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedTagDescriptionContractInner.innerProperties
                        = TagDescriptionContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTagDescriptionContractInner;
        });
    }
}
