// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Tag-operation link details.
 */
@Fluent
public final class TagOperationLinkContractInner extends ProxyResource {
    /*
     * Tag-API link entity contract properties.
     */
    private TagOperationLinkContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of TagOperationLinkContractInner class.
     */
    public TagOperationLinkContractInner() {
    }

    /**
     * Get the innerProperties property: Tag-API link entity contract properties.
     * 
     * @return the innerProperties value.
     */
    private TagOperationLinkContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the operationId property: Full resource Id of an API operation.
     * 
     * @return the operationId value.
     */
    public String operationId() {
        return this.innerProperties() == null ? null : this.innerProperties().operationId();
    }

    /**
     * Set the operationId property: Full resource Id of an API operation.
     * 
     * @param operationId the operationId value to set.
     * @return the TagOperationLinkContractInner object itself.
     */
    public TagOperationLinkContractInner withOperationId(String operationId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TagOperationLinkContractProperties();
        }
        this.innerProperties().withOperationId(operationId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TagOperationLinkContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TagOperationLinkContractInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TagOperationLinkContractInner.
     */
    public static TagOperationLinkContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TagOperationLinkContractInner deserializedTagOperationLinkContractInner
                = new TagOperationLinkContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedTagOperationLinkContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedTagOperationLinkContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedTagOperationLinkContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedTagOperationLinkContractInner.innerProperties
                        = TagOperationLinkContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTagOperationLinkContractInner;
        });
    }
}
