// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Tag-operation link entity properties.
 */
@Fluent
public final class TagOperationLinkContractProperties implements JsonSerializable<TagOperationLinkContractProperties> {
    /*
     * Full resource Id of an API operation.
     */
    private String operationId;

    /**
     * Creates an instance of TagOperationLinkContractProperties class.
     */
    public TagOperationLinkContractProperties() {
    }

    /**
     * Get the operationId property: Full resource Id of an API operation.
     * 
     * @return the operationId value.
     */
    public String operationId() {
        return this.operationId;
    }

    /**
     * Set the operationId property: Full resource Id of an API operation.
     * 
     * @param operationId the operationId value to set.
     * @return the TagOperationLinkContractProperties object itself.
     */
    public TagOperationLinkContractProperties withOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (operationId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property operationId in model TagOperationLinkContractProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TagOperationLinkContractProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operationId", this.operationId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TagOperationLinkContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TagOperationLinkContractProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TagOperationLinkContractProperties.
     */
    public static TagOperationLinkContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TagOperationLinkContractProperties deserializedTagOperationLinkContractProperties
                = new TagOperationLinkContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("operationId".equals(fieldName)) {
                    deserializedTagOperationLinkContractProperties.operationId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTagOperationLinkContractProperties;
        });
    }
}
