// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Tag-product link entity properties.
 */
@Fluent
public final class TagProductLinkContractProperties implements JsonSerializable<TagProductLinkContractProperties> {
    /*
     * Full resource Id of a product.
     */
    private String productId;

    /**
     * Creates an instance of TagProductLinkContractProperties class.
     */
    public TagProductLinkContractProperties() {
    }

    /**
     * Get the productId property: Full resource Id of a product.
     * 
     * @return the productId value.
     */
    public String productId() {
        return this.productId;
    }

    /**
     * Set the productId property: Full resource Id of a product.
     * 
     * @param productId the productId value to set.
     * @return the TagProductLinkContractProperties object itself.
     */
    public TagProductLinkContractProperties withProductId(String productId) {
        this.productId = productId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (productId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property productId in model TagProductLinkContractProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TagProductLinkContractProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("productId", this.productId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TagProductLinkContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TagProductLinkContractProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TagProductLinkContractProperties.
     */
    public static TagProductLinkContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TagProductLinkContractProperties deserializedTagProductLinkContractProperties
                = new TagProductLinkContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("productId".equals(fieldName)) {
                    deserializedTagProductLinkContractProperties.productId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTagProductLinkContractProperties;
        });
    }
}
