// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiTagResourceContractProperties;
import com.azure.resourcemanager.apimanagement.models.OperationTagResourceContractProperties;
import com.azure.resourcemanager.apimanagement.models.ProductTagResourceContractProperties;
import com.azure.resourcemanager.apimanagement.models.TagResourceContractProperties;
import java.io.IOException;

/**
 * TagResource contract properties.
 */
@Fluent
public final class TagResourceContractInner implements JsonSerializable<TagResourceContractInner> {
    /*
     * Tag associated with the resource.
     */
    private TagResourceContractProperties tag;

    /*
     * API associated with the tag.
     */
    private ApiTagResourceContractProperties api;

    /*
     * Operation associated with the tag.
     */
    private OperationTagResourceContractProperties operation;

    /*
     * Product associated with the tag.
     */
    private ProductTagResourceContractProperties product;

    /**
     * Creates an instance of TagResourceContractInner class.
     */
    public TagResourceContractInner() {
    }

    /**
     * Get the tag property: Tag associated with the resource.
     * 
     * @return the tag value.
     */
    public TagResourceContractProperties tag() {
        return this.tag;
    }

    /**
     * Set the tag property: Tag associated with the resource.
     * 
     * @param tag the tag value to set.
     * @return the TagResourceContractInner object itself.
     */
    public TagResourceContractInner withTag(TagResourceContractProperties tag) {
        this.tag = tag;
        return this;
    }

    /**
     * Get the api property: API associated with the tag.
     * 
     * @return the api value.
     */
    public ApiTagResourceContractProperties api() {
        return this.api;
    }

    /**
     * Set the api property: API associated with the tag.
     * 
     * @param api the api value to set.
     * @return the TagResourceContractInner object itself.
     */
    public TagResourceContractInner withApi(ApiTagResourceContractProperties api) {
        this.api = api;
        return this;
    }

    /**
     * Get the operation property: Operation associated with the tag.
     * 
     * @return the operation value.
     */
    public OperationTagResourceContractProperties operation() {
        return this.operation;
    }

    /**
     * Set the operation property: Operation associated with the tag.
     * 
     * @param operation the operation value to set.
     * @return the TagResourceContractInner object itself.
     */
    public TagResourceContractInner withOperation(OperationTagResourceContractProperties operation) {
        this.operation = operation;
        return this;
    }

    /**
     * Get the product property: Product associated with the tag.
     * 
     * @return the product value.
     */
    public ProductTagResourceContractProperties product() {
        return this.product;
    }

    /**
     * Set the product property: Product associated with the tag.
     * 
     * @param product the product value to set.
     * @return the TagResourceContractInner object itself.
     */
    public TagResourceContractInner withProduct(ProductTagResourceContractProperties product) {
        this.product = product;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (tag() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property tag in model TagResourceContractInner"));
        } else {
            tag().validate();
        }
        if (api() != null) {
            api().validate();
        }
        if (operation() != null) {
            operation().validate();
        }
        if (product() != null) {
            product().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TagResourceContractInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("tag", this.tag);
        jsonWriter.writeJsonField("api", this.api);
        jsonWriter.writeJsonField("operation", this.operation);
        jsonWriter.writeJsonField("product", this.product);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TagResourceContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TagResourceContractInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TagResourceContractInner.
     */
    public static TagResourceContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TagResourceContractInner deserializedTagResourceContractInner = new TagResourceContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tag".equals(fieldName)) {
                    deserializedTagResourceContractInner.tag = TagResourceContractProperties.fromJson(reader);
                } else if ("api".equals(fieldName)) {
                    deserializedTagResourceContractInner.api = ApiTagResourceContractProperties.fromJson(reader);
                } else if ("operation".equals(fieldName)) {
                    deserializedTagResourceContractInner.operation
                        = OperationTagResourceContractProperties.fromJson(reader);
                } else if ("product".equals(fieldName)) {
                    deserializedTagResourceContractInner.product
                        = ProductTagResourceContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTagResourceContractInner;
        });
    }
}
