// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Tenant Settings.
 */
@Fluent
public final class TenantSettingsContractInner extends ProxyResource {
    /*
     * TenantSettings entity contract properties.
     */
    private TenantSettingsContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of TenantSettingsContractInner class.
     */
    public TenantSettingsContractInner() {
    }

    /**
     * Get the innerProperties property: TenantSettings entity contract properties.
     * 
     * @return the innerProperties value.
     */
    private TenantSettingsContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the settings property: Tenant settings.
     * 
     * @return the settings value.
     */
    public Map<String, String> settings() {
        return this.innerProperties() == null ? null : this.innerProperties().settings();
    }

    /**
     * Set the settings property: Tenant settings.
     * 
     * @param settings the settings value to set.
     * @return the TenantSettingsContractInner object itself.
     */
    public TenantSettingsContractInner withSettings(Map<String, String> settings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TenantSettingsContractProperties();
        }
        this.innerProperties().withSettings(settings);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TenantSettingsContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TenantSettingsContractInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TenantSettingsContractInner.
     */
    public static TenantSettingsContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TenantSettingsContractInner deserializedTenantSettingsContractInner = new TenantSettingsContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedTenantSettingsContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedTenantSettingsContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedTenantSettingsContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedTenantSettingsContractInner.innerProperties
                        = TenantSettingsContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTenantSettingsContractInner;
        });
    }
}
