// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Tenant access information contract of the API Management service.
 */
@Fluent
public final class TenantSettingsContractProperties implements JsonSerializable<TenantSettingsContractProperties> {
    /*
     * Tenant settings
     */
    private Map<String, String> settings;

    /**
     * Creates an instance of TenantSettingsContractProperties class.
     */
    public TenantSettingsContractProperties() {
    }

    /**
     * Get the settings property: Tenant settings.
     * 
     * @return the settings value.
     */
    public Map<String, String> settings() {
        return this.settings;
    }

    /**
     * Set the settings property: Tenant settings.
     * 
     * @param settings the settings value to set.
     * @return the TenantSettingsContractProperties object itself.
     */
    public TenantSettingsContractProperties withSettings(Map<String, String> settings) {
        this.settings = settings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("settings", this.settings, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TenantSettingsContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TenantSettingsContractProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TenantSettingsContractProperties.
     */
    public static TenantSettingsContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TenantSettingsContractProperties deserializedTenantSettingsContractProperties
                = new TenantSettingsContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("settings".equals(fieldName)) {
                    Map<String, String> settings = reader.readMap(reader1 -> reader1.getString());
                    deserializedTenantSettingsContractProperties.settings = settings;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTenantSettingsContractProperties;
        });
    }
}
