// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.UserState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * User details.
 */
@Fluent
public final class UserContractInner extends ProxyResource {
    /*
     * User entity contract properties.
     */
    private UserContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of UserContractInner class.
     */
    public UserContractInner() {
    }

    /**
     * Get the innerProperties property: User entity contract properties.
     * 
     * @return the innerProperties value.
     */
    private UserContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the firstName property: First name.
     * 
     * @return the firstName value.
     */
    public String firstName() {
        return this.innerProperties() == null ? null : this.innerProperties().firstName();
    }

    /**
     * Set the firstName property: First name.
     * 
     * @param firstName the firstName value to set.
     * @return the UserContractInner object itself.
     */
    public UserContractInner withFirstName(String firstName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserContractProperties();
        }
        this.innerProperties().withFirstName(firstName);
        return this;
    }

    /**
     * Get the lastName property: Last name.
     * 
     * @return the lastName value.
     */
    public String lastName() {
        return this.innerProperties() == null ? null : this.innerProperties().lastName();
    }

    /**
     * Set the lastName property: Last name.
     * 
     * @param lastName the lastName value to set.
     * @return the UserContractInner object itself.
     */
    public UserContractInner withLastName(String lastName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserContractProperties();
        }
        this.innerProperties().withLastName(lastName);
        return this;
    }

    /**
     * Get the email property: Email address.
     * 
     * @return the email value.
     */
    public String email() {
        return this.innerProperties() == null ? null : this.innerProperties().email();
    }

    /**
     * Set the email property: Email address.
     * 
     * @param email the email value to set.
     * @return the UserContractInner object itself.
     */
    public UserContractInner withEmail(String email) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserContractProperties();
        }
        this.innerProperties().withEmail(email);
        return this;
    }

    /**
     * Get the registrationDate property: Date of user registration. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the registrationDate value.
     */
    public OffsetDateTime registrationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().registrationDate();
    }

    /**
     * Set the registrationDate property: Date of user registration. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @param registrationDate the registrationDate value to set.
     * @return the UserContractInner object itself.
     */
    public UserContractInner withRegistrationDate(OffsetDateTime registrationDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserContractProperties();
        }
        this.innerProperties().withRegistrationDate(registrationDate);
        return this;
    }

    /**
     * Get the groups property: Collection of groups user is part of.
     * 
     * @return the groups value.
     */
    public List<GroupContractProperties> groups() {
        return this.innerProperties() == null ? null : this.innerProperties().groups();
    }

    /**
     * Get the state property: Account state. Specifies whether the user is active or not. Blocked users are unable to
     * sign into the developer portal or call any APIs of subscribed products. Default state is Active.
     * 
     * @return the state value.
     */
    public UserState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Set the state property: Account state. Specifies whether the user is active or not. Blocked users are unable to
     * sign into the developer portal or call any APIs of subscribed products. Default state is Active.
     * 
     * @param state the state value to set.
     * @return the UserContractInner object itself.
     */
    public UserContractInner withState(UserState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserContractProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    /**
     * Get the note property: Optional note about a user set by the administrator.
     * 
     * @return the note value.
     */
    public String note() {
        return this.innerProperties() == null ? null : this.innerProperties().note();
    }

    /**
     * Set the note property: Optional note about a user set by the administrator.
     * 
     * @param note the note value to set.
     * @return the UserContractInner object itself.
     */
    public UserContractInner withNote(String note) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserContractProperties();
        }
        this.innerProperties().withNote(note);
        return this;
    }

    /**
     * Get the identities property: Collection of user identities.
     * 
     * @return the identities value.
     */
    public List<UserIdentityContractInner> identities() {
        return this.innerProperties() == null ? null : this.innerProperties().identities();
    }

    /**
     * Set the identities property: Collection of user identities.
     * 
     * @param identities the identities value to set.
     * @return the UserContractInner object itself.
     */
    public UserContractInner withIdentities(List<UserIdentityContractInner> identities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserContractProperties();
        }
        this.innerProperties().withIdentities(identities);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserContractInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the UserContractInner.
     */
    public static UserContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserContractInner deserializedUserContractInner = new UserContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedUserContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedUserContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedUserContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedUserContractInner.innerProperties = UserContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserContractInner;
        });
    }
}
