// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.UserEntityBaseParameters;
import com.azure.resourcemanager.apimanagement.models.UserState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * User profile.
 */
@Fluent
public final class UserContractProperties extends UserEntityBaseParameters {
    /*
     * First name.
     */
    private String firstName;

    /*
     * Last name.
     */
    private String lastName;

    /*
     * Email address.
     */
    private String email;

    /*
     * Date of user registration. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the
     * ISO 8601 standard.
     */
    private OffsetDateTime registrationDate;

    /*
     * Collection of groups user is part of.
     */
    private List<GroupContractProperties> groups;

    /**
     * Creates an instance of UserContractProperties class.
     */
    public UserContractProperties() {
    }

    /**
     * Get the firstName property: First name.
     * 
     * @return the firstName value.
     */
    public String firstName() {
        return this.firstName;
    }

    /**
     * Set the firstName property: First name.
     * 
     * @param firstName the firstName value to set.
     * @return the UserContractProperties object itself.
     */
    public UserContractProperties withFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    /**
     * Get the lastName property: Last name.
     * 
     * @return the lastName value.
     */
    public String lastName() {
        return this.lastName;
    }

    /**
     * Set the lastName property: Last name.
     * 
     * @param lastName the lastName value to set.
     * @return the UserContractProperties object itself.
     */
    public UserContractProperties withLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    /**
     * Get the email property: Email address.
     * 
     * @return the email value.
     */
    public String email() {
        return this.email;
    }

    /**
     * Set the email property: Email address.
     * 
     * @param email the email value to set.
     * @return the UserContractProperties object itself.
     */
    public UserContractProperties withEmail(String email) {
        this.email = email;
        return this;
    }

    /**
     * Get the registrationDate property: Date of user registration. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the registrationDate value.
     */
    public OffsetDateTime registrationDate() {
        return this.registrationDate;
    }

    /**
     * Set the registrationDate property: Date of user registration. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @param registrationDate the registrationDate value to set.
     * @return the UserContractProperties object itself.
     */
    public UserContractProperties withRegistrationDate(OffsetDateTime registrationDate) {
        this.registrationDate = registrationDate;
        return this;
    }

    /**
     * Get the groups property: Collection of groups user is part of.
     * 
     * @return the groups value.
     */
    public List<GroupContractProperties> groups() {
        return this.groups;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public UserContractProperties withState(UserState state) {
        super.withState(state);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public UserContractProperties withNote(String note) {
        super.withNote(note);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public UserContractProperties withIdentities(List<UserIdentityContractInner> identities) {
        super.withIdentities(identities);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (groups() != null) {
            groups().forEach(e -> e.validate());
        }
        if (identities() != null) {
            identities().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", state() == null ? null : state().toString());
        jsonWriter.writeStringField("note", note());
        jsonWriter.writeArrayField("identities", identities(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("firstName", this.firstName);
        jsonWriter.writeStringField("lastName", this.lastName);
        jsonWriter.writeStringField("email", this.email);
        jsonWriter.writeStringField("registrationDate",
            this.registrationDate == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.registrationDate));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserContractProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UserContractProperties.
     */
    public static UserContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserContractProperties deserializedUserContractProperties = new UserContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("state".equals(fieldName)) {
                    deserializedUserContractProperties.withState(UserState.fromString(reader.getString()));
                } else if ("note".equals(fieldName)) {
                    deserializedUserContractProperties.withNote(reader.getString());
                } else if ("identities".equals(fieldName)) {
                    List<UserIdentityContractInner> identities
                        = reader.readArray(reader1 -> UserIdentityContractInner.fromJson(reader1));
                    deserializedUserContractProperties.withIdentities(identities);
                } else if ("firstName".equals(fieldName)) {
                    deserializedUserContractProperties.firstName = reader.getString();
                } else if ("lastName".equals(fieldName)) {
                    deserializedUserContractProperties.lastName = reader.getString();
                } else if ("email".equals(fieldName)) {
                    deserializedUserContractProperties.email = reader.getString();
                } else if ("registrationDate".equals(fieldName)) {
                    deserializedUserContractProperties.registrationDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("groups".equals(fieldName)) {
                    List<GroupContractProperties> groups
                        = reader.readArray(reader1 -> GroupContractProperties.fromJson(reader1));
                    deserializedUserContractProperties.groups = groups;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserContractProperties;
        });
    }
}
